% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riemfactory.R
\name{riemfactory}
\alias{riemfactory}
\title{Prepare a S3 Class Object 'riemdata'}
\usage{
riemfactory(data, name = c("Euclidean", "Grassmann", "SPD", "Sphere",
  "Stiefel"))
}
\arguments{
\item{data}{data to be wrapped as \code{riemdata} class. Following input formats are considered,
\describe{
\item{2D array}{an \eqn{(m\times p)} matrix where data are stacked in columns over 2nd dimension. Appropriate for vector-valued \code{Euclidean} or \code{Sphere} manifold case.}
\item{3D array}{an \eqn{(m\times n\times p)} matrix where data are stacked in slices over 3rd dimension.}
\item{list}{unnamed list where each element of the list is a single data point. Sizes of all elements must match.}
}}

\item{name}{the name of Riemmanian manifold for data to which data belong.}
}
\value{
a named \code{riemdata} S3 object containing
\describe{
  \item{data}{a list of manifold-valued data points.}
  \item{size}{size of each data matrix.}
  \item{name}{name of the manifold of interests.}
}
}
\description{
Most of the functions for \code{RiemBase} package require data to be wrapped as a \code{riemdata} class. 
Since manifolds of interests endow data points with specific constraints, the function \code{riemfactory}
first checks the requirements to characterize the manifold and then wraps the data into 
\code{riemdata} class, which is simply a list of manifold-valued data and the name of manifold.
}
\examples{
\donttest{
### Here
}

}
