% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_cities.R
\docType{data}
\name{cities}
\alias{cities}
\title{Data : Populated Cities in the U.S.}
\format{
a named list containing\describe{
\item{names}{a length-\eqn{60} vector of city names.}
\item{coord}{a \eqn{(60\times 2)} matrix of latitude and longitude.}
\item{cartesian}{a \eqn{(60\times 3)} matrix of cartesian coordinates on the unit sphere.}
\item{population}{a length-\eqn{60} vector of cities' populations.}
}
}
\usage{
data(cities)
}
\description{
As of January 2006, there are 60 cities in the contiguous U.S. with population size 
larger than \eqn{300000}. We extracted information of the cities from the data 
delivered by \pkg{maps} package. Variables \code{coord} and \code{cartesian} are 
two identical representations of locations, which can be mutually converted by 
\code{\link{sphere.convert}}.
}
\examples{
\donttest{
## LOAD THE DATA AND WRAP AS RIEMOBJ
data(cities)
myriem = wrap.sphere(cities$cartesian)

## COMPUTE INTRINSIC/EXTRINSIC MEANS
intmean = as.vector(riem.mean(myriem, geometry="intrinsic")$mean)
extmean = as.vector(riem.mean(myriem, geometry="extrinsic")$mean)

## CONVERT TO GEOGRAPHIC COORDINATES (Lat/Lon)
geo.int = sphere.xyz2geo(intmean)
geo.ext = sphere.xyz2geo(extmean)
}

}
\seealso{
\code{\link{wrap.sphere}}
}
\concept{data}
\keyword{datasets}
