% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdmx_ilostat.R
\name{sdmx_ilostat}
\alias{sdmx_ilostat}
\title{Read Ilostat Data, Metadata via ILO SDMX api}
\usage{
sdmx_ilostat(
  dsd,
  sdmx_resource = getOption("ilostat_sdmx_resource", "codelist"),
  sdmx_format = "csv",
  lang = getOption("ilostat_lang", "en"),
  count = getOption("ilostat_sdmx_count", FALSE),
  quiet = getOption("ilostat_quiet", FALSE)
)
}
\arguments{
\item{dsd}{A datastructure definition, see \code{examples} section,}

\item{sdmx_resource}{: a character, type of info to be returned from the sdmx api: \code{'codelist'} (default), 
\code{'data'}, \code{'dataflow'}, \code{'conceptref'},}

\item{sdmx_format}{: for data only, a character, format of info to be returned from the sdmx api: \code{'csv'} (default) others no longer available.}

\item{lang}{a character for language. Available are \code{"en"} (default), 
\code{"fr"} and \code{"es"}. Can be set also with options(ilostat_lang = 'fr'),}

\item{count}{a logical, count data records only if \code{resource = 'data'}, \code{FALSE} (default),}

\item{quiet}{a logical, if \code{TRUE} , don't return message from processing, \code{FALSE} (default).
Can be set also with options(ilostat_quiet = TRUE).}
}
\description{
query codelist, data and metadata via ilo sdmx api
}
\examples{
\dontrun{
########## get codelist
# fetch indicator define on ILOSTAT
 dic <- sdmx_ilostat(dsd = "CL_INDICATOR", lang ="en")
 head(dic)

# fetch country available on ILOSTAT
 dic <- sdmx_ilostat(dsd = "CL_AREA", lang ="es")
 head(dic)

# fetch classif ECO version available on ILOSTAT
 dic <- sdmx_ilostat(dsd = "CL_ECO", lang ="en")
 head(dic)

# fetch note type available on ILOSTAT
 dic <- sdmx_ilostat(dsd = "CL_NOTE_TYPE", lang ="en")
 head(dic)

# fetch note "Repository" available on ILOSTAT
 dic <- sdmx_ilostat(dsd = "CL_NOTE_R1", lang ="en")
 head(dic)

######## get data

# to get the order of the filter first get the conceptref of the DSD

 filter_position <- sdmx_ilostat(dsd = 'EMP_TEMP_SEX_AGE_NB', 
 				   sdmx_resource = 'conceptref')
 filter_position

# COUNTRY and FREQ are in first and second position of the filters

 dat <- sdmx_ilostat(dsd = "EMP_TEMP_SEX_AGE_NB/FRA+DEU.Q...", 
                    sdmx_resource = 'data')
 head(dat)

### with attribute
 dat <- sdmx_ilostat(dsd = 'EMP_TEMP_SEX_AGE_NB/ARG.Q...', 
                    sdmx_resource = 'data')
 head(dat)

# without attribute
 dat <- sdmx_ilostat(dsd = "EMP_TEMP_SEX_AGE_NB/ARG.Q...?detail=dataonly", 
                    sdmx_resource = 'data')
 head(dat)


########## count data available

 sdmx_ilostat("UNE_TUNE_SEX_AGE_NB/FRA.Q...", 
                     sdmx_resource = 'data', count = TRUE)

}
}
\references{
See citation("Rilostat")

ilostat sdmx user guidelines:
\url{https://webapps.ilo.org/ilostat-files/Documents/SDMX_User_Guide.pdf}
}
\author{
David Bescond \email{bescond@ilo.org}
}
