# RiskPortfolios
Computation of risk-based portfolios in R

`RiskPortfolios` ([Ardia et al., 2017](http://dx.doi.org/10.21105/joss.00171)) is an R package for constructing risk-based portfolios dedicated to portfolio managers 
and quantitative analysts. It provides a set of functionalities to build mean-variance, minimum variance, inverse-volatility weighted, 
equal-risk-contribution, maximum diversification, and risk-efficient portfolios. As risk-based portfolios are
mainly based on covariances, the package also provides a large set of covariance matrix estimators. See [Ardia et al. (2017)](http://dx.doi.org/10.21105/joss.00171) for details. A Monte Carlo study relying on `RiskPortfolios` is presented in [Ardia et al. (2017)](http://dx.doi.org/10.1007/s10479-017-2474-7).

The latest stable version of `RiskPortfolios` is available at [https://cran.r-project.org/package=RiskPortfolios](https://cran.r-project.org/package=RiskPortfolios).

The latest development version of `RiskPortfolios` is available at [https://github.com/ArdiaD/RiskPortfolios](https://github.com/ArdiaD/RiskPortfolios).

Please cite `RiskPortfolios` in publications:

Ardia, D., Bolliger, G., Boudt, K., Gagnon-Fleury, J.-P. (2017).      
The impact of covariance misspecification in risk-based portfolios.      
_Annals of Operations Research_ **254**(1--2), pp 1-16.      
[http://dx.doi.org/10.1007/s10479-017-2474-7](http://dx.doi.org/10.1007/s10479-017-2474-7)   
[http://dx.doi.org/10.2139/ssrn.2650644](http://dx.doi.org/10.2139/ssrn.2650644) 
   
Ardia, D., Boudt, K., Gagnon-Fleury, J.-P. (2017).      
RiskPortfolios: Computation of risk-based portfolios in R.        
_Journal of Open Source Software_ **10**(2).    
[http://dx.doi.org/10.21105/joss.00171](http://dx.doi.org/10.21105/joss.00171)      