% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moments.R
\name{kurtCoeff}
\alias{kurtCoeff}
\title{Adjusted Fisher-Pearson Excess Sample Kurtosis}
\usage{
kurtCoeff(data, sd)
}
\arguments{
\item{data}{The data for which kurtosis is computed (vector)}

\item{sd}{The population standard deviation, used to compute kurtosis (scalar)}
}
\value{
The kurtosis value (scalar)
}
\description{
Adjusted Fisher-Pearson Excess Sample Kurtosis
}
\examples{
values <- rnorm(100)
x <- kurtCoeff(data = values, sd = sd(values))
}
\references{
Shreve, Joni N. and Donna Dea Holland . 2018. SAS® Certification Prep
            Guide: Statistical Business Analysis Using SAS®9. Cary, NC: SAS Institute Inc.
}
