/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.xbean;

import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.usage.SystemUsage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XBeanBrokerService
extends BrokerService {
    private static final transient Log LOG = LogFactory.getLog(XBeanBrokerService.class);
    private boolean start = true;

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.ensureSystemUsageHasStore();
        if (this.shouldAutostart()) {
            this.start();
        }
    }

    protected boolean shouldAutostart() {
        return this.start;
    }

    private void ensureSystemUsageHasStore() throws IOException {
        SystemUsage usage = this.getSystemUsage();
        if (usage.getStoreUsage().getStore() == null) {
            usage.getStoreUsage().setStore(this.getPersistenceAdapter());
        }
        if (usage.getTempUsage().getStore() == null) {
            usage.getTempUsage().setStore(this.getTempDataStore());
        }
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.stop();
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    @Deprecated
    public void setDestroyApplicationContextOnShutdown(boolean destroy) {
        LOG.warn("destroyApplicationContextOnShutdown parameter is deprecated, please use shutdown hooks instead");
    }

    @Deprecated
    public void setDestroyApplicationContextOnStop(boolean destroy) {
        LOG.warn("destroyApplicationContextOnStop parameter is deprecated, please use shutdown hooks instead");
    }
}

