/*
    rstanarm is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rstanarm is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rstanarm.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0

#include <stan/model/model_header.hpp>

namespace model_LGT_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_LGT");
    reader.add_event(97, 95, "end", "model_LGT");
    return reader;
}

class model_LGT
  : public stan::model::model_base_crtp<model_LGT> {
private:
        double CAUCHY_SD;
        double MIN_POW_TREND;
        double MAX_POW_TREND;
        double MIN_SIGMA;
        double MIN_NU;
        double MAX_NU;
        int N;
        vector_d y;
        double POW_TREND_ALPHA;
        double POW_TREND_BETA;
        int USE_REGRESSION;
        int USE_SMOOTHED_ERROR;
        int J;
        matrix_d xreg;
        vector_d REG_CAUCHY_SD;
        double reg0CauchySd;
public:
    model_LGT(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_LGT(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_LGT_namespace::model_LGT";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            // initialize data block variables from context__
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "CAUCHY_SD", "double", context__.to_vec());
            CAUCHY_SD = double(0);
            vals_r__ = context__.vals_r("CAUCHY_SD");
            pos__ = 0;
            CAUCHY_SD = vals_r__[pos__++];
            check_greater_or_equal(function__, "CAUCHY_SD", CAUCHY_SD, 0);

            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "MIN_POW_TREND", "double", context__.to_vec());
            MIN_POW_TREND = double(0);
            vals_r__ = context__.vals_r("MIN_POW_TREND");
            pos__ = 0;
            MIN_POW_TREND = vals_r__[pos__++];

            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "MAX_POW_TREND", "double", context__.to_vec());
            MAX_POW_TREND = double(0);
            vals_r__ = context__.vals_r("MAX_POW_TREND");
            pos__ = 0;
            MAX_POW_TREND = vals_r__[pos__++];

            current_statement_begin__ = 6;
            context__.validate_dims("data initialization", "MIN_SIGMA", "double", context__.to_vec());
            MIN_SIGMA = double(0);
            vals_r__ = context__.vals_r("MIN_SIGMA");
            pos__ = 0;
            MIN_SIGMA = vals_r__[pos__++];
            check_greater_or_equal(function__, "MIN_SIGMA", MIN_SIGMA, 0);

            current_statement_begin__ = 7;
            context__.validate_dims("data initialization", "MIN_NU", "double", context__.to_vec());
            MIN_NU = double(0);
            vals_r__ = context__.vals_r("MIN_NU");
            pos__ = 0;
            MIN_NU = vals_r__[pos__++];
            check_greater_or_equal(function__, "MIN_NU", MIN_NU, 1);

            current_statement_begin__ = 7;
            context__.validate_dims("data initialization", "MAX_NU", "double", context__.to_vec());
            MAX_NU = double(0);
            vals_r__ = context__.vals_r("MAX_NU");
            pos__ = 0;
            MAX_NU = vals_r__[pos__++];
            check_greater_or_equal(function__, "MAX_NU", MAX_NU, 1);

            current_statement_begin__ = 8;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);

            current_statement_begin__ = 9;
            validate_non_negative_index("y", "N", N);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(N));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "y", y, 0);

            current_statement_begin__ = 10;
            context__.validate_dims("data initialization", "POW_TREND_ALPHA", "double", context__.to_vec());
            POW_TREND_ALPHA = double(0);
            vals_r__ = context__.vals_r("POW_TREND_ALPHA");
            pos__ = 0;
            POW_TREND_ALPHA = vals_r__[pos__++];
            check_greater_or_equal(function__, "POW_TREND_ALPHA", POW_TREND_ALPHA, 0);

            current_statement_begin__ = 10;
            context__.validate_dims("data initialization", "POW_TREND_BETA", "double", context__.to_vec());
            POW_TREND_BETA = double(0);
            vals_r__ = context__.vals_r("POW_TREND_BETA");
            pos__ = 0;
            POW_TREND_BETA = vals_r__[pos__++];
            check_greater_or_equal(function__, "POW_TREND_BETA", POW_TREND_BETA, 0);

            current_statement_begin__ = 11;
            context__.validate_dims("data initialization", "USE_REGRESSION", "int", context__.to_vec());
            USE_REGRESSION = int(0);
            vals_i__ = context__.vals_i("USE_REGRESSION");
            pos__ = 0;
            USE_REGRESSION = vals_i__[pos__++];
            check_greater_or_equal(function__, "USE_REGRESSION", USE_REGRESSION, 0);
            check_less_or_equal(function__, "USE_REGRESSION", USE_REGRESSION, 1);

            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "USE_SMOOTHED_ERROR", "int", context__.to_vec());
            USE_SMOOTHED_ERROR = int(0);
            vals_i__ = context__.vals_i("USE_SMOOTHED_ERROR");
            pos__ = 0;
            USE_SMOOTHED_ERROR = vals_i__[pos__++];
            check_greater_or_equal(function__, "USE_SMOOTHED_ERROR", USE_SMOOTHED_ERROR, 0);
            check_less_or_equal(function__, "USE_SMOOTHED_ERROR", USE_SMOOTHED_ERROR, 1);

            current_statement_begin__ = 13;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            check_greater_or_equal(function__, "J", J, 1);

            current_statement_begin__ = 14;
            validate_non_negative_index("xreg", "N", N);
            validate_non_negative_index("xreg", "J", J);
            context__.validate_dims("data initialization", "xreg", "matrix_d", context__.to_vec(N,J));
            xreg = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, J);
            vals_r__ = context__.vals_r("xreg");
            pos__ = 0;
            size_t xreg_j_2_max__ = J;
            size_t xreg_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < xreg_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < xreg_j_1_max__; ++j_1__) {
                    xreg(j_1__, j_2__) = vals_r__[pos__++];
                }
            }

            current_statement_begin__ = 15;
            validate_non_negative_index("REG_CAUCHY_SD", "J", J);
            context__.validate_dims("data initialization", "REG_CAUCHY_SD", "vector_d", context__.to_vec(J));
            REG_CAUCHY_SD = Eigen::Matrix<double, Eigen::Dynamic, 1>(J);
            vals_r__ = context__.vals_r("REG_CAUCHY_SD");
            pos__ = 0;
            size_t REG_CAUCHY_SD_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < REG_CAUCHY_SD_j_1_max__; ++j_1__) {
                REG_CAUCHY_SD(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "REG_CAUCHY_SD", REG_CAUCHY_SD, 0);


            // initialize transformed data variables
            current_statement_begin__ = 18;
            reg0CauchySd = double(0);
            stan::math::fill(reg0CauchySd, DUMMY_VAR__);
            stan::math::assign(reg0CauchySd,(mean(REG_CAUCHY_SD) * 10));

            // execute transformed data statements

            // validate transformed data
            current_statement_begin__ = 18;
            check_greater_or_equal(function__, "reg0CauchySd", reg0CauchySd, 0);


            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 21;
            validate_non_negative_index("regCoef", "J", J);
            num_params_r__ += J;
            current_statement_begin__ = 21;
            num_params_r__ += 1;
            current_statement_begin__ = 22;
            num_params_r__ += 1;
            current_statement_begin__ = 23;
            num_params_r__ += 1;
            current_statement_begin__ = 24;
            num_params_r__ += 1;
            current_statement_begin__ = 25;
            num_params_r__ += 1;
            current_statement_begin__ = 26;
            num_params_r__ += 1;
            current_statement_begin__ = 27;
            num_params_r__ += 1;
            current_statement_begin__ = 28;
            num_params_r__ += 1;
            current_statement_begin__ = 29;
            num_params_r__ += 1;
            current_statement_begin__ = 30;
            num_params_r__ += 1;
            current_statement_begin__ = 31;
            num_params_r__ += 1;
            current_statement_begin__ = 32;
            num_params_r__ += 1;
            current_statement_begin__ = 33;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_LGT() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        current_statement_begin__ = 21;
        if (!(context__.contains_r("regCoef")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable regCoef missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("regCoef");
        pos__ = 0U;
        validate_non_negative_index("regCoef", "J", J);
        context__.validate_dims("parameter initialization", "regCoef", "vector_d", context__.to_vec(J));
        Eigen::Matrix<double, Eigen::Dynamic, 1> regCoef(J);
        size_t regCoef_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < regCoef_j_1_max__; ++j_1__) {
            regCoef(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(regCoef);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable regCoef: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 21;
        if (!(context__.contains_r("regOffset")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable regOffset missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("regOffset");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "regOffset", "double", context__.to_vec());
        double regOffset(0);
        regOffset = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(regOffset);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable regOffset: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 22;
        if (!(context__.contains_r("nu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable nu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("nu");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "nu", "double", context__.to_vec());
        double nu(0);
        nu = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(MIN_NU, MAX_NU, nu);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable nu: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 23;
        if (!(context__.contains_r("sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma", "double", context__.to_vec());
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 24;
        if (!(context__.contains_r("levSm")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable levSm missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("levSm");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "levSm", "double", context__.to_vec());
        double levSm(0);
        levSm = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, levSm);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable levSm: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 25;
        if (!(context__.contains_r("bSm")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable bSm missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("bSm");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "bSm", "double", context__.to_vec());
        double bSm(0);
        bSm = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, bSm);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable bSm: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 26;
        if (!(context__.contains_r("powx")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable powx missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("powx");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "powx", "double", context__.to_vec());
        double powx(0);
        powx = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, powx);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable powx: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 27;
        if (!(context__.contains_r("bInit")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable bInit missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("bInit");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "bInit", "double", context__.to_vec());
        double bInit(0);
        bInit = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(bInit);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable bInit: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 28;
        if (!(context__.contains_r("powTrendBeta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable powTrendBeta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("powTrendBeta");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "powTrendBeta", "double", context__.to_vec());
        double powTrendBeta(0);
        powTrendBeta = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, powTrendBeta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable powTrendBeta: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 29;
        if (!(context__.contains_r("coefTrend")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable coefTrend missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("coefTrend");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "coefTrend", "double", context__.to_vec());
        double coefTrend(0);
        coefTrend = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(coefTrend);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable coefTrend: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 30;
        if (!(context__.contains_r("offsetSigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable offsetSigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("offsetSigma");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "offsetSigma", "double", context__.to_vec());
        double offsetSigma(0);
        offsetSigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(MIN_SIGMA, offsetSigma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable offsetSigma: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 31;
        if (!(context__.contains_r("locTrendFract")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable locTrendFract missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("locTrendFract");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "locTrendFract", "double", context__.to_vec());
        double locTrendFract(0);
        locTrendFract = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, locTrendFract);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable locTrendFract: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 32;
        if (!(context__.contains_r("innovSm")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable innovSm missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("innovSm");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "innovSm", "double", context__.to_vec());
        double innovSm(0);
        innovSm = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, innovSm);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable innovSm: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 33;
        if (!(context__.contains_r("innovSizeInit")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable innovSizeInit missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("innovSizeInit");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "innovSizeInit", "double", context__.to_vec());
        double innovSizeInit(0);
        innovSizeInit = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, innovSizeInit);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable innovSizeInit: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);

            // model parameters
            current_statement_begin__ = 21;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> regCoef;
            (void) regCoef;  // dummy to suppress unused var warning
            if (jacobian__)
                regCoef = in__.vector_constrain(J, lp__);
            else
                regCoef = in__.vector_constrain(J);

            current_statement_begin__ = 21;
            local_scalar_t__ regOffset;
            (void) regOffset;  // dummy to suppress unused var warning
            if (jacobian__)
                regOffset = in__.scalar_constrain(lp__);
            else
                regOffset = in__.scalar_constrain();

            current_statement_begin__ = 22;
            local_scalar_t__ nu;
            (void) nu;  // dummy to suppress unused var warning
            if (jacobian__)
                nu = in__.scalar_lub_constrain(MIN_NU, MAX_NU, lp__);
            else
                nu = in__.scalar_lub_constrain(MIN_NU, MAX_NU);

            current_statement_begin__ = 23;
            local_scalar_t__ sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.scalar_lb_constrain(0, lp__);
            else
                sigma = in__.scalar_lb_constrain(0);

            current_statement_begin__ = 24;
            local_scalar_t__ levSm;
            (void) levSm;  // dummy to suppress unused var warning
            if (jacobian__)
                levSm = in__.scalar_lub_constrain(0, 1, lp__);
            else
                levSm = in__.scalar_lub_constrain(0, 1);

            current_statement_begin__ = 25;
            local_scalar_t__ bSm;
            (void) bSm;  // dummy to suppress unused var warning
            if (jacobian__)
                bSm = in__.scalar_lub_constrain(0, 1, lp__);
            else
                bSm = in__.scalar_lub_constrain(0, 1);

            current_statement_begin__ = 26;
            local_scalar_t__ powx;
            (void) powx;  // dummy to suppress unused var warning
            if (jacobian__)
                powx = in__.scalar_lub_constrain(0, 1, lp__);
            else
                powx = in__.scalar_lub_constrain(0, 1);

            current_statement_begin__ = 27;
            local_scalar_t__ bInit;
            (void) bInit;  // dummy to suppress unused var warning
            if (jacobian__)
                bInit = in__.scalar_constrain(lp__);
            else
                bInit = in__.scalar_constrain();

            current_statement_begin__ = 28;
            local_scalar_t__ powTrendBeta;
            (void) powTrendBeta;  // dummy to suppress unused var warning
            if (jacobian__)
                powTrendBeta = in__.scalar_lub_constrain(0, 1, lp__);
            else
                powTrendBeta = in__.scalar_lub_constrain(0, 1);

            current_statement_begin__ = 29;
            local_scalar_t__ coefTrend;
            (void) coefTrend;  // dummy to suppress unused var warning
            if (jacobian__)
                coefTrend = in__.scalar_constrain(lp__);
            else
                coefTrend = in__.scalar_constrain();

            current_statement_begin__ = 30;
            local_scalar_t__ offsetSigma;
            (void) offsetSigma;  // dummy to suppress unused var warning
            if (jacobian__)
                offsetSigma = in__.scalar_lb_constrain(MIN_SIGMA, lp__);
            else
                offsetSigma = in__.scalar_lb_constrain(MIN_SIGMA);

            current_statement_begin__ = 31;
            local_scalar_t__ locTrendFract;
            (void) locTrendFract;  // dummy to suppress unused var warning
            if (jacobian__)
                locTrendFract = in__.scalar_lub_constrain(0, 1, lp__);
            else
                locTrendFract = in__.scalar_lub_constrain(0, 1);

            current_statement_begin__ = 32;
            local_scalar_t__ innovSm;
            (void) innovSm;  // dummy to suppress unused var warning
            if (jacobian__)
                innovSm = in__.scalar_lub_constrain(0, 1, lp__);
            else
                innovSm = in__.scalar_lub_constrain(0, 1);

            current_statement_begin__ = 33;
            local_scalar_t__ innovSizeInit;
            (void) innovSizeInit;  // dummy to suppress unused var warning
            if (jacobian__)
                innovSizeInit = in__.scalar_lb_constrain(0, lp__);
            else
                innovSizeInit = in__.scalar_lb_constrain(0);

            // transformed parameters
            current_statement_begin__ = 36;
            local_scalar_t__ powTrend;
            (void) powTrend;  // dummy to suppress unused var warning
            stan::math::initialize(powTrend, DUMMY_VAR__);
            stan::math::fill(powTrend, DUMMY_VAR__);

            current_statement_begin__ = 37;
            validate_non_negative_index("l", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> l(N);
            stan::math::initialize(l, DUMMY_VAR__);
            stan::math::fill(l, DUMMY_VAR__);

            current_statement_begin__ = 38;
            validate_non_negative_index("b", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> b(N);
            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b, DUMMY_VAR__);

            current_statement_begin__ = 39;
            validate_non_negative_index("r", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> r(N);
            stan::math::initialize(r, DUMMY_VAR__);
            stan::math::fill(r, DUMMY_VAR__);

            current_statement_begin__ = 40;
            validate_non_negative_index("expVal", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> expVal(N);
            stan::math::initialize(expVal, DUMMY_VAR__);
            stan::math::fill(expVal, DUMMY_VAR__);

            current_statement_begin__ = 41;
            validate_non_negative_index("smoothedInnovSize", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> smoothedInnovSize(N);
            stan::math::initialize(smoothedInnovSize, DUMMY_VAR__);
            stan::math::fill(smoothedInnovSize, DUMMY_VAR__);

            // transformed parameters block statements
            current_statement_begin__ = 43;
            if (as_bool(USE_REGRESSION)) {
                current_statement_begin__ = 44;
                stan::math::assign(r, add(multiply(xreg, regCoef), regOffset));
            } else {
                current_statement_begin__ = 46;
                stan::math::assign(r, rep_vector(0, N));
            }
            current_statement_begin__ = 48;
            if (as_bool(USE_SMOOTHED_ERROR)) {
                current_statement_begin__ = 49;
                stan::model::assign(smoothedInnovSize, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            innovSizeInit, 
                            "assigning variable smoothedInnovSize");
            } else {
                current_statement_begin__ = 51;
                stan::model::assign(smoothedInnovSize, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            1, 
                            "assigning variable smoothedInnovSize");
            }
            current_statement_begin__ = 53;
            stan::model::assign(l, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        (get_base1(y, 1, "y", 1) - get_base1(r, 1, "r", 1)), 
                        "assigning variable l");
            current_statement_begin__ = 54;
            stan::model::assign(b, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        bInit, 
                        "assigning variable b");
            current_statement_begin__ = 55;
            stan::math::assign(powTrend, (((MAX_POW_TREND - MIN_POW_TREND) * powTrendBeta) + MIN_POW_TREND));
            current_statement_begin__ = 56;
            stan::model::assign(expVal, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        get_base1(y, 1, "y", 1), 
                        "assigning variable expVal");
            current_statement_begin__ = 58;
            for (int t = 2; t <= N; ++t) {

                current_statement_begin__ = 59;
                stan::model::assign(expVal, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            (((get_base1(l, (t - 1), "l", 1) + (coefTrend * pow(get_base1(l, (t - 1), "l", 1), powTrend))) + (locTrendFract * get_base1(b, (t - 1), "b", 1))) + get_base1(r, t, "r", 1)), 
                            "assigning variable expVal");
                current_statement_begin__ = 60;
                stan::model::assign(l, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            ((levSm * (get_base1(y, t, "y", 1) - get_base1(r, t, "r", 1))) + ((1 - levSm) * get_base1(l, (t - 1), "l", 1))), 
                            "assigning variable l");
                current_statement_begin__ = 61;
                stan::model::assign(b, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            ((bSm * (get_base1(l, t, "l", 1) - get_base1(l, (t - 1), "l", 1))) + (((1 - bSm) * locTrendFract) * get_base1(b, (t - 1), "b", 1))), 
                            "assigning variable b");
                current_statement_begin__ = 63;
                if (as_bool(USE_SMOOTHED_ERROR)) {
                    current_statement_begin__ = 64;
                    stan::model::assign(smoothedInnovSize, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                ((innovSm * stan::math::fabs((get_base1(y, t, "y", 1) - get_base1(expVal, t, "expVal", 1)))) + ((1 - innovSm) * get_base1(smoothedInnovSize, (t - 1), "smoothedInnovSize", 1))), 
                                "assigning variable smoothedInnovSize");
                } else {
                    current_statement_begin__ = 66;
                    stan::model::assign(smoothedInnovSize, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                1, 
                                "assigning variable smoothedInnovSize");
                }
            }

            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            current_statement_begin__ = 36;
            if (stan::math::is_uninitialized(powTrend)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: powTrend";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable powTrend: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            check_greater_or_equal(function__, "powTrend", powTrend, MIN_POW_TREND);
            check_less_or_equal(function__, "powTrend", powTrend, MAX_POW_TREND);

            current_statement_begin__ = 37;
            size_t l_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < l_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(l(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: l" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable l: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "l", l, 0);

            current_statement_begin__ = 38;
            size_t b_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(b(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: b" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable b: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 39;
            size_t r_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < r_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(r(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: r" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable r: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 40;
            size_t expVal_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < expVal_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(expVal(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: expVal" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable expVal: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "expVal", expVal, 0);

            current_statement_begin__ = 41;
            size_t smoothedInnovSize_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < smoothedInnovSize_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(smoothedInnovSize(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: smoothedInnovSize" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable smoothedInnovSize: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "smoothedInnovSize", smoothedInnovSize, 0);


            // model body

            current_statement_begin__ = 70;
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, CAUCHY_SD));
            if (sigma < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else lp_accum__.add(-cauchy_ccdf_log(0, 0, CAUCHY_SD));
            current_statement_begin__ = 71;
            lp_accum__.add(cauchy_log<propto__>(offsetSigma, MIN_SIGMA, CAUCHY_SD));
            if (offsetSigma < MIN_SIGMA) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else lp_accum__.add(-cauchy_ccdf_log(MIN_SIGMA, MIN_SIGMA, CAUCHY_SD));
            current_statement_begin__ = 72;
            lp_accum__.add(cauchy_log<propto__>(coefTrend, 0, CAUCHY_SD));
            current_statement_begin__ = 73;
            lp_accum__.add(beta_log<propto__>(powTrendBeta, POW_TREND_ALPHA, POW_TREND_BETA));
            current_statement_begin__ = 75;
            if (as_bool(USE_SMOOTHED_ERROR)) {
                current_statement_begin__ = 76;
                lp_accum__.add(cauchy_log<propto__>(innovSizeInit, (get_base1(y, 1, "y", 1) / 100), CAUCHY_SD));
                if (innovSizeInit < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                else lp_accum__.add(-cauchy_ccdf_log(0, (get_base1(y, 1, "y", 1) / 100), CAUCHY_SD));
            } else {
                current_statement_begin__ = 78;
                lp_accum__.add(normal_log<propto__>(innovSizeInit, 0, 1));
                if (innovSizeInit < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                else lp_accum__.add(-normal_ccdf_log(0, 0, 1));
            }
            current_statement_begin__ = 80;
            if (as_bool(USE_REGRESSION)) {

                current_statement_begin__ = 81;
                lp_accum__.add(cauchy_log<propto__>(regCoef, 0, REG_CAUCHY_SD));
                current_statement_begin__ = 82;
                lp_accum__.add(cauchy_log<propto__>(regOffset, 0, reg0CauchySd));
            } else {

                current_statement_begin__ = 84;
                lp_accum__.add(normal_log<propto__>(regCoef, 0, 1));
                current_statement_begin__ = 85;
                lp_accum__.add(normal_log<propto__>(regOffset, 0, 1));
            }
            current_statement_begin__ = 87;
            lp_accum__.add(cauchy_log<propto__>(bInit, 0, CAUCHY_SD));
            current_statement_begin__ = 89;
            for (int t = 2; t <= N; ++t) {

                current_statement_begin__ = 90;
                if (as_bool(logical_eq(USE_SMOOTHED_ERROR, 0))) {
                    current_statement_begin__ = 91;
                    lp_accum__.add(student_t_log<propto__>(get_base1(y, t, "y", 1), nu, get_base1(expVal, t, "expVal", 1), ((sigma * pow(get_base1(expVal, t, "expVal", 1), powx)) + offsetSigma)));
                } else {
                    current_statement_begin__ = 93;
                    lp_accum__.add(student_t_log<propto__>(get_base1(y, t, "y", 1), nu, get_base1(expVal, t, "expVal", 1), ((sigma * get_base1(smoothedInnovSize, (t - 1), "smoothedInnovSize", 1)) + offsetSigma)));
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("regCoef");
        names__.push_back("regOffset");
        names__.push_back("nu");
        names__.push_back("sigma");
        names__.push_back("levSm");
        names__.push_back("bSm");
        names__.push_back("powx");
        names__.push_back("bInit");
        names__.push_back("powTrendBeta");
        names__.push_back("coefTrend");
        names__.push_back("offsetSigma");
        names__.push_back("locTrendFract");
        names__.push_back("innovSm");
        names__.push_back("innovSizeInit");
        names__.push_back("powTrend");
        names__.push_back("l");
        names__.push_back("b");
        names__.push_back("r");
        names__.push_back("expVal");
        names__.push_back("smoothedInnovSize");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_LGT_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning

        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> regCoef = in__.vector_constrain(J);
        size_t regCoef_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < regCoef_j_1_max__; ++j_1__) {
            vars__.push_back(regCoef(j_1__));
        }

        double regOffset = in__.scalar_constrain();
        vars__.push_back(regOffset);

        double nu = in__.scalar_lub_constrain(MIN_NU, MAX_NU);
        vars__.push_back(nu);

        double sigma = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma);

        double levSm = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(levSm);

        double bSm = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(bSm);

        double powx = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(powx);

        double bInit = in__.scalar_constrain();
        vars__.push_back(bInit);

        double powTrendBeta = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(powTrendBeta);

        double coefTrend = in__.scalar_constrain();
        vars__.push_back(coefTrend);

        double offsetSigma = in__.scalar_lb_constrain(MIN_SIGMA);
        vars__.push_back(offsetSigma);

        double locTrendFract = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(locTrendFract);

        double innovSm = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(innovSm);

        double innovSizeInit = in__.scalar_lb_constrain(0);
        vars__.push_back(innovSizeInit);

        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        if (!include_tparams__ && !include_gqs__) return;

        try {
            // declare and define transformed parameters
            current_statement_begin__ = 36;
            double powTrend;
            (void) powTrend;  // dummy to suppress unused var warning
            stan::math::initialize(powTrend, DUMMY_VAR__);
            stan::math::fill(powTrend, DUMMY_VAR__);

            current_statement_begin__ = 37;
            validate_non_negative_index("l", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> l(N);
            stan::math::initialize(l, DUMMY_VAR__);
            stan::math::fill(l, DUMMY_VAR__);

            current_statement_begin__ = 38;
            validate_non_negative_index("b", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> b(N);
            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b, DUMMY_VAR__);

            current_statement_begin__ = 39;
            validate_non_negative_index("r", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> r(N);
            stan::math::initialize(r, DUMMY_VAR__);
            stan::math::fill(r, DUMMY_VAR__);

            current_statement_begin__ = 40;
            validate_non_negative_index("expVal", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> expVal(N);
            stan::math::initialize(expVal, DUMMY_VAR__);
            stan::math::fill(expVal, DUMMY_VAR__);

            current_statement_begin__ = 41;
            validate_non_negative_index("smoothedInnovSize", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> smoothedInnovSize(N);
            stan::math::initialize(smoothedInnovSize, DUMMY_VAR__);
            stan::math::fill(smoothedInnovSize, DUMMY_VAR__);

            // do transformed parameters statements
            current_statement_begin__ = 43;
            if (as_bool(USE_REGRESSION)) {
                current_statement_begin__ = 44;
                stan::math::assign(r, add(multiply(xreg, regCoef), regOffset));
            } else {
                current_statement_begin__ = 46;
                stan::math::assign(r, rep_vector(0, N));
            }
            current_statement_begin__ = 48;
            if (as_bool(USE_SMOOTHED_ERROR)) {
                current_statement_begin__ = 49;
                stan::model::assign(smoothedInnovSize, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            innovSizeInit, 
                            "assigning variable smoothedInnovSize");
            } else {
                current_statement_begin__ = 51;
                stan::model::assign(smoothedInnovSize, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            1, 
                            "assigning variable smoothedInnovSize");
            }
            current_statement_begin__ = 53;
            stan::model::assign(l, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        (get_base1(y, 1, "y", 1) - get_base1(r, 1, "r", 1)), 
                        "assigning variable l");
            current_statement_begin__ = 54;
            stan::model::assign(b, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        bInit, 
                        "assigning variable b");
            current_statement_begin__ = 55;
            stan::math::assign(powTrend, (((MAX_POW_TREND - MIN_POW_TREND) * powTrendBeta) + MIN_POW_TREND));
            current_statement_begin__ = 56;
            stan::model::assign(expVal, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        get_base1(y, 1, "y", 1), 
                        "assigning variable expVal");
            current_statement_begin__ = 58;
            for (int t = 2; t <= N; ++t) {

                current_statement_begin__ = 59;
                stan::model::assign(expVal, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            (((get_base1(l, (t - 1), "l", 1) + (coefTrend * pow(get_base1(l, (t - 1), "l", 1), powTrend))) + (locTrendFract * get_base1(b, (t - 1), "b", 1))) + get_base1(r, t, "r", 1)), 
                            "assigning variable expVal");
                current_statement_begin__ = 60;
                stan::model::assign(l, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            ((levSm * (get_base1(y, t, "y", 1) - get_base1(r, t, "r", 1))) + ((1 - levSm) * get_base1(l, (t - 1), "l", 1))), 
                            "assigning variable l");
                current_statement_begin__ = 61;
                stan::model::assign(b, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            ((bSm * (get_base1(l, t, "l", 1) - get_base1(l, (t - 1), "l", 1))) + (((1 - bSm) * locTrendFract) * get_base1(b, (t - 1), "b", 1))), 
                            "assigning variable b");
                current_statement_begin__ = 63;
                if (as_bool(USE_SMOOTHED_ERROR)) {
                    current_statement_begin__ = 64;
                    stan::model::assign(smoothedInnovSize, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                ((innovSm * stan::math::fabs((get_base1(y, t, "y", 1) - get_base1(expVal, t, "expVal", 1)))) + ((1 - innovSm) * get_base1(smoothedInnovSize, (t - 1), "smoothedInnovSize", 1))), 
                                "assigning variable smoothedInnovSize");
                } else {
                    current_statement_begin__ = 66;
                    stan::model::assign(smoothedInnovSize, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                1, 
                                "assigning variable smoothedInnovSize");
                }
            }

            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            current_statement_begin__ = 36;
            check_greater_or_equal(function__, "powTrend", powTrend, MIN_POW_TREND);
            check_less_or_equal(function__, "powTrend", powTrend, MAX_POW_TREND);

            current_statement_begin__ = 37;
            check_greater_or_equal(function__, "l", l, 0);

            current_statement_begin__ = 40;
            check_greater_or_equal(function__, "expVal", expVal, 0);

            current_statement_begin__ = 41;
            check_greater_or_equal(function__, "smoothedInnovSize", smoothedInnovSize, 0);

            // write transformed parameters
            if (include_tparams__) {
                vars__.push_back(powTrend);
                size_t l_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < l_j_1_max__; ++j_1__) {
                    vars__.push_back(l(j_1__));
                }
                size_t b_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                    vars__.push_back(b(j_1__));
                }
                size_t r_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < r_j_1_max__; ++j_1__) {
                    vars__.push_back(r(j_1__));
                }
                size_t expVal_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < expVal_j_1_max__; ++j_1__) {
                    vars__.push_back(expVal(j_1__));
                }
                size_t smoothedInnovSize_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < smoothedInnovSize_j_1_max__; ++j_1__) {
                    vars__.push_back(smoothedInnovSize(j_1__));
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    std::string model_name() const {
        return "model_LGT";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t regCoef_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < regCoef_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "regCoef" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "regOffset";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "nu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "levSm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bSm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "powx";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bInit";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "powTrendBeta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "coefTrend";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "offsetSigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "locTrendFract";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "innovSm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "innovSizeInit";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "powTrend";
            param_names__.push_back(param_name_stream__.str());
            size_t l_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < l_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "l" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t r_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < r_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "r" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t expVal_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < expVal_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "expVal" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t smoothedInnovSize_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < smoothedInnovSize_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "smoothedInnovSize" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t regCoef_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < regCoef_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "regCoef" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "regOffset";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "nu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "levSm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bSm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "powx";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bInit";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "powTrendBeta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "coefTrend";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "offsetSigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "locTrendFract";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "innovSm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "innovSizeInit";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "powTrend";
            param_names__.push_back(param_name_stream__.str());
            size_t l_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < l_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "l" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t r_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < r_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "r" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t expVal_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < expVal_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "expVal" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t smoothedInnovSize_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < smoothedInnovSize_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "smoothedInnovSize" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
    }

}; // model

}  // namespace

typedef model_LGT_namespace::model_LGT stan_model;

#ifndef USING_R

stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}

#endif


#endif
