\name{histCluster}
\alias{histCluster}
\title{Histogram of a class [\code{\linkS4class{MixmodResults}}]}
\usage{
  histCluster(x, data, variables = colnames(data),
    xlab = rep("", length(variables)),
    main = paste("Histogram of", variables), hist_x_dim=10000, ...)
}
\arguments{
  \item{x}{an object of class
  [\code{\linkS4class{MixmodResults}}]}

  \item{data}{a vector or data frame containing a
  quantitative data set.}

  \item{variables}{list of variables names (or indices) to
  compute a histogram. All variables from data by default.}

  \item{xlab}{a list of title for the x axis. xlab must
  have the same length than variables.}

  \item{main}{a list of title for the histogram. main must
  have the same length than variables.}

  \item{hist_x_dim}{number of values on the x axis.}

  \item{...}{further arguments passed to or from other
  methods}
}
\description{
  Histograms of data object using parameters from a
  [\code{\linkS4class{MixmodResults}}] to plot densities.
}
\details{
  Data with the density of each cluster and the mixture
  density are drawn for each variable.
}
\examples{
data(geyser)
  xem1 <- mixmodCluster(geyser,3)
  \dontrun{ histCluster(xem1["bestResult"], geyser) }
  histCluster(xem1["bestResult"], geyser, variables=1)
}
\seealso{
  \code{\link{hist}}
}

