\name{createsurvey}
\alias{createsurvey}
\title{Create survey}
\description{Create a new survey (and collector) from a survey template}
\usage{
createsurvey(template = NULL, survey = NULL, title, collector_name = NULL,
             type = 'email', recipients = NULL, email_replyto = NULL,
             email_subject = NULL, email_body = NULL,
             api_key = getOption('sm_api_key'),
             oauth_token = getOption('sm_oauth_token'), ...)
}
\arguments{
\item{template}{A Survey Monkey template ID number, possibly returned by \code{\link{templates}}. Must specify either \code{template} xor \code{survey}.}
\item{survey}{A Survey Monkey survey ID number (or an object of class \dQuote{sm_survey} from which it can be extracted), possibly returned by \code{\link{surveylist}}. Must specify either \code{template} xor \code{survey}.}
\item{title}{A character string to use as the title of the survey.}
\item{collector_name}{A character string to use as the name of the collector. If \code{NULL}, the default \dQuote{New Email Invitation} will be used.}
\item{type}{Type of collector to create. Currently only allowed value is \dQuote{email}. Weblink collectors can be created using \code{\link{createcollector}}.}
\item{recipients}{A list of a list for each recipient containing email addresses and potentially first names, last names, and a \dQuote{Custom ID} for each recipient. Only email address is required. User can specify vectors between 1 and 4 items long. If lists do not have element names, items in each list are assumed to be email address, first name, last name, and custom ID (in that order). If supplied in a different order, each list element must be named: \code{email}, \code{first_name}, \code{last_name}, and \code{custom_id}.}
\item{email_replyto}{A character string containing the reply-to email address for the survey.}
\item{email_subject}{A character string containing the subject line for the email to be sent to recipients.}
\item{email_body}{A character string containing the body of an email to be sent to recipients. The string should contain \code{[SurveyLink]} as a placeholder for the survey link and \code{[OptOutLink]} as a placeholder for the standard Survey Monkey opt-out.  Unless you have a Gold or Platinum 
account and have opted out of notification, you also need to include the footer link, \code{[FooterLink]}.}
\item{api_key}{Your API key. By default, retrieved from \code{getOption('sm_api_key')}.}
\item{oauth_token}{Your OAuth 2.0 token, as generated by \code{\link{smlogin}}. By default, retrieved from \code{getOption('sm_oauth_token')}.}
\item{...}{Other arguments passed to \code{\link[httr]{POST}}.}
}
\details{Creates a new survey from a template or by copying an existing survey and generates an email collector for the specified survey. Survey Monkey BASIC users can only have three collectors per survey. Requesting more will result in a message with additional information about upgrading your account.}
\value{A list containing an object of class \code{sm_collector}, an object of class \code{sm_survey}, and additional details.}
\references{
\url{https://developer.surveymonkey.com/mashery/create_flow}
}
\author{Thomas J. Leeper}
%\note{}
%\seealso{}
\examples{
\dontrun{
smlogin()

# create survey by copying existing survey
s <- surveylist()
createsurvey(survey = s[[1]]$survey_id, title = 'Copied survey',
    collector_name='Emails', 
    recipients = list(list('first@example.com'), list('second@example.com')),
    email_replyto='me@example.com', email_subject='Please complete a short survey!')

# create survey from template
tmps <- templates()
createsurvey(template = tmps[[1]]$template_id, title = 'Copied survey',
    collector_name='Emails', 
    recipients = list(list('first@example.com'), list('second@example.com')),
    email_replyto='me@example.com', email_subject='Please complete a short survey!')    
}
}
%\keyword{}
