% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadings.R
\name{loadings}
\alias{loadings}
\title{Print Loadings in NEST}
\usage{
loadings(x, nfactors = x$nfactors, method = x$method, ...)
}
\arguments{
\item{x}{An object of class "nest".}

\item{nfactors}{The number of factors to retains.}

\item{method}{A method used to compute loadings and uniquenesses.}

\item{...}{Further arguments to methods in "nest" or the \code{stats::loadings} function.}
}
\value{
A \eqn{p \times k} matrix containing loadings where \eqn{p} is the number of variables and \eqn{k} is the number of factors (\code{nfactors}).
}
\description{
Print Loadings in NEST
}
\note{
See \code{stats::loadings} for the original documentation.
}
\examples{
results <- nest(ex_2factors, n = 100)
loadings(results)
}
