% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateMetadata.R
\name{generateMetadata}
\alias{generateMetadata}
\title{generateMetadata}
\usage{
generateMetadata(RAWDIR, procParams, samples = NULL)
}
\arguments{
\item{RAWDIR}{The full path of either the raw spectra directory on the disk}

\item{procParams}{the list of processing parameters. First initialize this list with the \code{Spec1r.Procpar.default} list, then modify parameters depending of your spectra set.}

\item{samples}{the samples matrix with the correspondence of the raw spectra}
}
\value{
\code{generateMetadata} returns a list containing the following components:
\itemize{
  \item \code{samples} : the samples matrix with the correspondence of the raw spectra, as well as the levels of the experimental factors if specified in the input.
  \item \code{factors} : the factors matrix with the corresponding factor names. At minimum, the list contains the Samplecode label corresponding to the samples without their group level.
  \item \code{rawids} : list of the full directories of the raw spectra (i.e. where the FID files are accessible)
}
}
\description{
\code{generateMetadata} Generate the metadata from the list of raw spectra namely the samples, the experimental factors and the list of selected raw spectra. Depending on whether the sample matrix is supplied as input or not,
}
\examples{
data_dir <- system.file("extra", package = "Rnmr1D")
samplefile <- file.path(data_dir, "Samples.txt")
samples <- read.table(samplefile, sep="\\t", header=TRUE,stringsAsFactors=FALSE)
metadata <- generateMetadata(data_dir, procParams=Spec1rProcpar, samples)

}
