% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{RoBTT}
\alias{RoBTT}
\title{Estimate a Robust Bayesian T-Test}
\usage{
RoBTT(
  x1 = NULL,
  x2 = NULL,
  mean1 = NULL,
  mean2 = NULL,
  sd1 = NULL,
  sd2 = NULL,
  N1 = NULL,
  N2 = NULL,
  truncation = NULL,
  prior_delta = prior(distribution = "cauchy", parameters = list(location = 0, scale =
    sqrt(2)/2)),
  prior_rho = prior(distribution = "beta", parameters = list(alpha = 1, beta = 1)),
  prior_nu = if (is.null(truncation)) prior(distribution = "exp", parameters = list(rate
    = 1)),
  prior_delta_null = prior(distribution = "spike", parameters = list(location = 0)),
  prior_rho_null = prior(distribution = "spike", parameters = list(location = 0.5)),
  prior_nu_null = prior_none(),
  prior_mu = NULL,
  prior_sigma2 = NULL,
  chains = 4,
  iter = 10000,
  warmup = 5000,
  thin = 1,
  parallel = FALSE,
  control = set_control(),
  convergence_checks = set_convergence_checks(),
  save = "all",
  seed = NULL,
  silent = TRUE,
  ...
)
}
\arguments{
\item{x1}{vector of observations of the first group}

\item{x2}{vector of observations of the second group}

\item{mean1}{mean of the first group}

\item{mean2}{mean of the first group}

\item{sd1}{standard deviation of the first group}

\item{sd2}{standard deviation of the first group}

\item{N1}{sample size of the first group}

\item{N2}{sample size of the first group}

\item{truncation}{an optional list specifying truncation applied to the data.
Defaults to \code{NULL}, i.e., no truncation was applied and the full likelihood is
applied. Alternative the truncation can be specified via a named list with:
\describe{
\item{\code{"x"}}{where \code{x} is a vector of two values specifying the lower
and upper truncation points common across the groups}
\item{\code{"x1"} and \code{"x2"}}{where \code{x1} is a vector of two values specifying
the lower and upper truncation points for the first group and \code{x2} is a vector of
two values specifying the lower and upper truncation points for the second group.}
\item{\code{"sigma"}}{where \code{sigma} corresponds to the number of standard deviations
from the common mean where the truncation points should be set.}
\item{\code{"sigma1"} and \code{"sigma2"}}{where \code{sigma1} corresponds to the number of
standard deviations from the mean of the first group where the truncation points should be set
and \code{sigma2} corresponds to the number of standard deviations from the mean of the second
group where the truncation points should be set.}
}}

\item{prior_delta}{prior distributions for the effect size \code{delta} parameter
that will be treated as belonging to the alternative hypothesis. Defaults to \code{
prior(distribution = "Cauchy", parameters = list(location = 0, scale = sqrt(2)/2))}.}

\item{prior_rho}{prior distributions for the precision allocation \code{rho} parameter
that will be treated as belonging to the alternative hypothesis. Defaults to \code{
prior(distribution = "beta", parameters = list(alpha = 1, beta = 1))}.}

\item{prior_nu}{prior distribution for the degrees of freedom + 2 \code{nu}
parameter that will be treated as belonging to the alternative hypothesis.
Defaults to \code{prior(distribution = "exp", parameters = list(rate = 1))} if no
\code{truncation} is specified. If \code{truncation} is specified, the default is
\code{NULL} (i.e., use only normal likelihood).}

\item{prior_delta_null}{prior distribution for the \code{delta} parameter that
will be treated as belonging to the null hypothesis. Defaults to point distribution
with location at 0 (
\code{prior(distribution = "point", parameters = list(location = 0))}).}

\item{prior_rho_null}{prior distribution for the \code{rho} parameter that
will be treated as belonging to the null hypothesis. Defaults to point distribution
with location at 0.5 (
\code{prior(distribution = "point", parameters = list(location = 0.5))}).}

\item{prior_nu_null}{prior distribution for the \code{nu} parameter
that will be treated as belonging to the null hypothesis. Defaults to \code{prior_none} (
(i.e., normal likelihood)).}

\item{prior_mu}{prior distribution for the grand mean parameter. Defaults to \code{NULL}
which sets Jeffreys prior for the grand mean in case of no truncation or an unit Cauchy
prior distributions for the grand mean in case of truncation (which greatly improves
sampling efficiency).}

\item{prior_sigma2}{prior distribution for the grand variance parameter. Defaults to \code{NULL}
which sets Jeffreys prior for the variance in case of no truncation or an exponential prior
distribution for the variance in case of truncation (which greatly improves sampling efficiency).}

\item{chains}{a number of chains of the MCMC algorithm.}

\item{iter}{a number of sampling iterations of the MCMC algorithm.
Defaults to \code{10000}, with a minimum of \code{4000}.}

\item{warmup}{a number of warmup  iterations of the MCMC algorithm.
Defaults to \code{5000}.}

\item{thin}{a thinning of the chains of the MCMC algorithm. Defaults to
\code{1}.}

\item{parallel}{whether the individual models should be fitted in parallel.
Defaults to \code{FALSE}. The implementation is not completely stable
and might cause a connection error.}

\item{control}{allows to pass control settings with the
\code{\link[=set_control]{set_control()}} function. See \code{?set_control} for
options and default settings.}

\item{convergence_checks}{automatic convergence checks to assess the fitted
models, passed with \code{\link[=set_convergence_checks]{set_convergence_checks()}} function. See
\code{?set_convergence_checks} for options and default settings.}

\item{save}{whether all models posterior distributions should be kept
after obtaining a model-averaged result. Defaults to \code{"all"} which
does not remove anything. Set to \code{"min"} to significantly reduce
the size of final object, however, some model diagnostics and further
manipulation with the object will not be possible.}

\item{seed}{a seed to be set before model fitting, marginal likelihood
computation, and posterior mixing for reproducibility of results. Defaults
to \code{NULL} - no seed is set.}

\item{silent}{whether all print messages regarding the fitting process
should be suppressed. Defaults to \code{TRUE}. Note that \code{parallel = TRUE}
also suppresses all messages.}

\item{...}{additional arguments.}
}
\value{
\code{RoBTT} returns an object of \link[base]{class} \code{"RoBTT"}.
}
\description{
\code{RoBTT} is used to estimate a robust Bayesian
t-test or truncated Bayesian t-test (if \code{truncation} is used).
The input either requires the vector of observations for
each group, \code{x1, x2}, or the summary statistics (only if the normal
likelihood models are used).
}
\details{
See \insertCite{maier2022bayesian;textual}{RoBTT} for more details
regarding the robust Bayesian t-test methodology and the corresponding
vignette (\href{../doc/Introduction_to_RoBTT.html}{\code{vignette("Introduction_to_RoBTT", package = "RoBTT")}}).

See \insertCite{godmann2024how;textual}{RoBTT} for more details
regarding the truncated Bayesian t-test methodology and the corresponding
vignette (\href{../doc/Truncated_t_test.html}{\code{vignette("Truncated_t_test", package = "RoBTT")}}).

Generic \code{\link[=summary.RoBTT]{summary.RoBTT()}}, \code{\link[=print.RoBTT]{print.RoBTT()}}, and \code{\link[=plot.RoBTT]{plot.RoBTT()}}
functions are provided to facilitate manipulation with the ensemble.
}
\examples{
\dontrun{
# using the example data from Darwin
data("fertilization", package = "RoBTT")
fit <- RoBTT(
  x1       = fertilization$Self,
  x2       = fertilization$Crossed,
  prior_delta = prior("cauchy", list(0, 1/sqrt(2))),
  prior_rho   = prior("beta",   list(3, 3)),
  seed        = 1, 
  chains      = 1,
  warmup      = 1000,
  iter        = 2000,
  control     = set_control(adapt_delta = 0.95)
)

# summary can provide many details about the model
summary(fit)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=summary.RoBTT]{summary.RoBTT()}}, \code{\link[=prior]{prior()}}
}
