% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Multirobu.R
\name{covRob}
\alias{covRob}
\alias{Multirobu}
\title{Robust multivariate location and scatter estimators}
\usage{
covRob(X, type = "auto", maxit = 50, tol = 1e-04)
}
\arguments{
\item{X}{a data matrix with observations in rows.}

\item{type}{a string indicating which estimator to compute. Valid options
are "Rocke" for Rocke's S-estimator, "MM" for an MM-estimator with a
SHR rho function, or "auto" (default) which selects "Rocke" if the number
of variables is greater than or equal to 10, and "MM" otherwise.}

\item{maxit}{Maximum number of iterations, defaults to 50.}

\item{tol}{Tolerance for convergence, defaults to 1e-4.}
}
\value{
A list with class \dQuote{covClassic} with the following components:
\item{mu}{The location estimate}
\item{V}{The scatter matrix estimate, scaled for consistency at the normal distribution}
\item{center}{The location estimate. Same as \code{mu} above.}
\item{cov}{The scatter matrix estimate, scaled for consistency at the normal distribution. Same as \code{V} above.}
\item{dist}{Robust Mahalanobis distances}
}
\description{
This function computes robust estimators for multivariate location and scatter.
}
\details{
This function computes robust estimators for multivariate location and scatter.
The default behaviour (\code{type = "auto"}) computes a "Rocke" estimator
(as implemented in \code{\link{covRobRocke}}) if the number
of variables is greater than or equal to 10, and an MM-estimator with a
SHR rho function (as implemented in \code{\link{covRobMM}}) otherwise.
}
\examples{
data(bus)
X0 <- as.matrix(bus)
X1 <- X0[,-9]
tmp <- covRob(X1)
round(tmp$cov[1:10, 1:10], 3)
tmp$mu

}
\references{
\url{http://www.wiley.com/go/maronna/robust}
}
\seealso{
\code{\link{covRobRocke}}, \code{\link{covRobMM}}
}
\author{
Ricardo Maronna, \email{rmaronna@retina.ar}
}
