% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KurtSDNew.R
\name{initPP}
\alias{initPP}
\alias{KurtSDNew}
\title{Robust multivariate location and scatter estimators}
\usage{
initPP(X, muldirand = 20, muldifix = 10, dirmin = 1000)
}
\arguments{
\item{X}{a data matrix with observations in rows.}

\item{muldirand}{used to determine the number of random directions (candidates), which
is \code{max(p*muldirand, dirmin)}, where \code{p} is the number of columns in \code{X}.}

\item{muldifix}{used to determine the number of random directions (candidates), which
is \code{min(n, 2*muldifix*p)}.}

\item{dirmin}{minimum number of random directions}
}
\value{
A list with the following components:
\item{idx}{A zero/one vector with ones in the positions of the suspected outliers}
\item{disma}{Robust squared Mahalanobis distances}
\item{center}{Robust mean estimate}
\item{cova}{Robust covariance matrix estimate}
\item{t}{Outlyingness of data points}
}
\description{
This function computes robust multivariate location and scatter
estimators using both random and deterministic starting points.
}
\details{
This function computes robust multivariate location and scatter
using both Pen~a-Prieto and random candidates.
}
\examples{
data(bus)
X0 <- as.matrix(bus)
X1 <- X0[,-9]
tmp <- initPP(X1)
round(tmp$cov[1:10, 1:10], 3)
tmp$center

}
\references{
\url{http://www.wiley.com/go/maronna/robust}
}
\author{
Ricardo Maronna, \email{rmaronna@retina.ar}, based on original code
by D. Pen~a and J. Prieto
}
