% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odamws.R
\docType{class}
\name{odamws-class}
\alias{odamws-class}
\alias{odamws}
\title{API layer for the ODAM web services}
\description{
the class that implements the API layer for the ODAM (Open Data for Access and Mining) web services.

Provides functions to allow you to retrieve online data using ODAM Web Services. This obviously requires that data are implemented according the ODAM approach (Open Data for Access and Mining), namely that the data subsets were deposited in the suitable data repository in the form of TSV files associated with  their metadata also described  in TSV files.
}
\section{Fields}{

\describe{
\item{\code{wsURL}}{defines the URL of the webservice - Must be specify when creating a new instance of the odamws object.}

\item{\code{dsname}}{specifies the name of the Dataset to query - Must be specify when creating a new instance of the odamws object.}

\item{\code{auth}}{specifies the authentication code to access to the Dataset by this webservice (if required)}

\item{\code{subsets}}{a data.frame object containing metadata related to the data subsets - Initialized during the instantiation step}

\item{\code{subsetNames}}{a list of the data subset names - Initialized during the instantiation step}

\item{\code{connectList}}{a matrix of the connection graph between data subsets (i.e. the links between each subset with the subset at its origin, so that links can be interpreted as 'obtained from'). The data subsets are referred by their subset number. (corresponding to the 'SetID' column in the 'subsets' field)  - Initialized during the instantiation step.}
}}

\section{Methods}{

\describe{
\item{\code{getCommonID(refID, setName1, setName2)}}{Returns the list of  identifiers (defined by refID as an identifier attribute label) that are in common between two subsets (defined by the attribute label of the setName1 and setName2 subsets) i.e. resulting in the intersection of the two identifier sets.}

\item{\code{getDataByName(setName, condition = "")}}{Returns the data of the 'setName' subset as a data.frame}

\item{\code{getDataTree()}}{Returns a data.tree object filled up  according to the data subset metadata}

\item{\code{getMerged(refID, setName1, setName2)}}{Returns a data.frame containing data obtained by merging two subsets (defined by the attribute label of the setName1 and setName2 subsets) that have the same identifiers in common (defined by refID as an identifier attribute label)  i.e. resulting in the intersection of the two identifier sets.}

\item{\code{getSubsetByName(setName, condition = "")}}{Returns both data and metadate of the 'setName' subset as an  object list:

        data - a data.frame object containing the data. The column names of this data.frame are gathered according their categories and avaivalble in embedded lists, and described below.

        varnames, facnames, qualnames,  - Return lists containing  the 'quantitative' variables, the 'factor' variables,  the 'qualitative ' variables  respectively.

        samplename - a data.frame containing the metadata about the data subset, namely its name (Subset), its identifier (Attribute), its description (Description), its type (Type), and its CVTerm (CV_Term_ID, CV_Term_Name)

        LABELS - a data.frame containing the metadata about all attributes - its format is the same as the 'samplename' data.frame.

        WSEntry - a data.frame containing the correspondance between some attributes and their alias name, these latter serving within a query to put a constraint a or selection on this attribute. Note: a 'WSEntry' is an alias name associated with an attribute that allows user to query the data subset by putting a filter condition (i.e. a selection constraint) on the corresponding attribute. Not all attributes have a WSEntry but only few ones, especially the attributes within the identifier and factor categories. For instance, the WSEntry of the 'SampleID' attribute is 'sample'. Thus, if you want to select only samples with their ID equal to 365, you have to specify the filter condition as  'sample/365'.}

\item{\code{getWS(query = "")}}{Low level routine allowing to retrieve data or metadata from  a query formatted according the ODAM framework specifications - Returns a data.frame object. By default, i.e. with an empty query, a data.frame object containing metadata related to the data subsets is returned.}
}}

\examples{
\dontrun{
dh <- new("odamws", "https://pmb-bordeaux.fr/pmb/getdata/", "frim1")
dn <- show(dh)
# Get data from 'samples' subset with a constraint
data <- dh$getDataByName('samples','sample/365')
 # Get 'activome' data subset
ds <- dh$getSubsetByName('activome')
# Get the merged data of both data subsets based on their common identifier
refID <- "SampleID"
setName1 <- "activome"
setName2 <- "qNMR_metabo"
dsMerged <- dh$getMerged(refID, setName1, setName2)
}
}
\author{
Daniel Jacob - INRA UMR 1332 BFP (C) 2016
}
