\name{RI.hybridFS.FRST}
\alias{RI.hybridFS.FRST}
\title{Hybrid fuzzy-rough rule and induction and feature selection}
\usage{
  RI.hybridFS.FRST(decision.table, control = list())
}
\arguments{
  \item{decision.table}{a \code{"DecisionTable"} class
  representing the decision table. See
  \code{\link{SF.asDecisionTable}}.}

  \item{control}{a list of other parameters which consist
  of \itemize{ \item \code{type.aggregation} a list
  representing the type of aggregation. The default value
  is \code{type.aggregation = c("t.tnorm", "lukasiewicz")}.

  See \code{\link{BC.IND.relation.FRST}}.  \item
  \code{type.relation} the type of indiscernibility
  relation. The default value is \code{type.relation =
  c("tolerance", "eq.3")}.  See
  \code{\link{BC.IND.relation.FRST}}.  \item
  \code{t.implicator} the type of implication function. The
  default value is \code{"lukasiewicz"}.  See
  BC.LU.approximation.FRST.  }}
}
\value{
  A class \code{"RuleSetFRST"} which has similar components
  as \code{\link{RI.GFRS.FRST}} but in this case the
  \code{threshold} component is not included.
}
\description{
  It is a function for generating rules based on hybrid
  fuzzy-rough rule induction and feature selection. It
  allows for classification and regression tasks.
}
\details{
  It was proposed by (R. Jensen et al, 2009) attempting to
  combine rule induction and feature selection at the same
  time. Basically this algorithm inserts some steps to
  generate rules into the fuzzy QuickReduct algorithm (see
  \code{\link{FS.quickreduct.FRST}}. Furthermore, by
  introducing the degree of coverage, this algorithm
  selects proper rules.

  This function allows not only for classification but also
  for regression problems. After obtaining the rules,
  predicting can be done by calling \code{predict} or
  \code{\link{predict.RuleSetFRST}}. Additionally, to get
  better representation we can execute
  \code{link{summary}}.
}
\examples{
###########################################################
## Example 1: Regression problem
###########################################################
data(RoughSetData)
decision.table <- RoughSetData$housing7.dt

control <- list(type.aggregation = c("t.tnorm", "lukasiewicz"), type.relation =
                c("tolerance", "eq.3"), t.implicator = "lukasiewicz")
res.1 <- RI.hybridFS.FRST(decision.table, control)

###########################################################
## Example 2: Classification problem
##############################################################
data(RoughSetData)
decision.table <- RoughSetData$pima7.dt

control <- list(type.aggregation = c("t.tnorm", "lukasiewicz"), type.relation =
                c("tolerance", "eq.3"), t.implicator = "lukasiewicz")
res.2 <- RI.hybridFS.FRST(decision.table, control)
}
\references{
  R. Jensen, C. Cornelis, and Q. Shen, "Hybrid Fuzzy-rough
  Rule Induction and Feature Selection", in: IEEE
  International Conference on Fuzzy Systems (FUZZ-IEEE), p.
  1151 - 1156 (2009).
}
\seealso{
  \code{\link{RI.indiscernibilityBasedRules.RST}},
  \code{\link{predict.RuleSetFRST}}, and
  \code{\link{RI.GFRS.FRST}}.
}

