% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/persons.add.picture.R
\name{persons.add.picture}
\alias{persons.add.picture}
\title{Add person picture}
\usage{
persons.add.picture(id, file, crop_x = NULL, crop_y = NULL,
  crop_width = NULL, crop_height = NULL, api_token = NULL,
  company_domain = "api", return_type = c("complete", "boolean"))
}
\arguments{
\item{id}{ID of the person}

\item{file}{One image supplied in the multipart/form-data encoding.}

\item{crop_x}{X coordinate to where start cropping form (in pixels)}

\item{crop_y}{Y coordinate to where start cropping form (in pixels)}

\item{crop_width}{Width of cropping area (in pixels)}

\item{crop_height}{Height of cropping area (in pixels)}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}

\item{return_type}{the default return is an object List with all informations of process, or you can set boolean (TRUE = success, FALSE = error)}
}
\value{
customizable return, the default is an object List
}
\description{
Function to Add person picture on pipedrive.
}
\examples{
\donttest{
persons.add.picture(id='e.g.',file='e.g.',api_token='token',company_domain='exp')
}
}
