% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_panel_grid.R
\name{multi_panel_grid}
\alias{multi_panel_grid}
\title{multi_panel_grid}
\usage{
multi_panel_grid(
  layout = NULL,
  title = NULL,
  title_fontsz = 20,
  plot_titles = NULL,
  y_tick_width = 0.5,
  cell_width = 8,
  cell_height = 8,
  do_grid = FALSE
)
}
\arguments{
\item{layout}{A list containing a list for plot objects or \code{grob} "plots", row locations "rows" vector,
column locations "cols" vector. This argument is required.}

\item{title}{A string that sets the title of the figure.}

\item{title_fontsz}{A numeric that sets the title's font size. The default is 20.}

\item{plot_titles}{A character vector with the same length as the number of plot objects that defines
each of their titles. The parameter is used only if 'do_grid' is \code{FALSE}.}

\item{y_tick_width}{A numeric that sets the width of the vertical column containing the y axis tick labeling.
The default is 0.5 cm and may be increased when a wider labeling is needed.}

\item{cell_width}{A numeric that sets the cell widths in the \code{gtable} in cm}

\item{cell_height}{A numeric that sets the cell widths in the \code{gtable} in cm}

\item{do_grid}{A logical which if \code{TRUE} will arrange the plot objects according to 'layout' without considering
their scale and label components. You define the axis scaling, titling, etc for each
individual plot object.}
}
\value{
A ggplot2 class object
}
\description{
Arranges a group of ggplot2 plots or grid::grob's into multiple panels.

  Function creates a figure with title and arranges multiple plots/\code{grob}s
  across a given number of rows and columns. The function depends on the \code{grid},
  \code{gtable}, and \code{ggplotify} packages.
}
\details{
The function has two modes of layout: a grid and a non-grid. In the grid layout, each plot
 submitted will be laid out "as-is" with no manipulation of labels, legends, or axis'.

 For the non-grid layout, the function goes beyond just placing a group of plots across a
 grid of rows and columns. It is somewhat opinionated in favor of common titling/labeling and scaling
 that make sense for all the plots and provide the ability to compare. The function has a
 'title' parameter that is assumed appropriate for all the plots--any titles/subtitles
 among the plots themselves will be removed.  The first left y-axis
 scaling the function comes across will be used for all the plots. Similarly the first bottom
 x-axis scaling the function comes across will be assumed appropriate for all the plots. The
 first legend that is found is assumed right for all the plots and will be placed at the top
 in a horizontal direction. Of course none of these sub-elements among the plots need to exist
 and you are back to simply a grid of plots.

 As an example of defining the 'layout' list argument,
 'layout' has three named elements: "plots", "rows", and "cols".
 "plots" is a list of ggplot2 plot objects; "rows" defines the row number
 for each plot and "cols" defines the column number for each plot. If we have
 two plots with both plots on a single row then "rows" = c(1,1) and "cols"
 = c(1,2).
}
\examples{
library(ggplot2)
library(ggplotify)
library(rlang)
library(grid)
library(gtable)
library(ggplotify)
library(purrr)
library(RplotterPkg)

years <- levels(RplotterPkg::gapminder_data$year)
build_plot <- function(id, dt, years){
  plot_dt <- dt[year == years[[id]], ]
  aplot <- RplotterPkg::create_scatter_plot(
    df = plot_dt,
    aes_x = "lifeExp",
    aes_y = "pop",
    aes_fill = "continent",
    x_limits = c(20, 80),
    x_major_breaks = seq(from = 20, to = 80, by = 10),
    y_limits = c(0, 400),
    y_major_breaks = seq(from = 0, to = 400, by = 50),
    subtitle = years[[id]],
    title = "Life Expectancy Across Continents",
    x_title = "Life Expectancy",
    y_title = "Population(1e+6)",
    pts_size = 5,
    legend_key_width = 0.8,
    legend_key_height = 0.6,
    show_minor_grids = FALSE,
    silent_NA_warning = TRUE
  )
  return(aplot)
}
plot_lst <- purrr::map(1:4,
  build_plot,
  dt = RplotterPkg::gapminder_data,
  years = years
)
layout <- list(
  plots = plot_lst,
  rows = c(1, 1, 1, 1),
  cols = c(1, 2, 3, 4)
)
RplotterPkg::multi_panel_grid(
  layout = layout,
  title = "Life expectancy vs population(millions) across continents",
  plot_titles = c("1952","1972","1992","2002"),
  cell_height = 12
)

}
