% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gibbs_loop}
\alias{gibbs_loop}
\title{Routine to perform Gibbs sampling for the LCMMNP model}
\usage{
gibbs_loop(
  R,
  B,
  nprint,
  N,
  Jm1,
  P_f,
  P_r,
  C,
  lcus,
  suff_statistics,
  prior,
  init
)
}
\arguments{
\item{R}{An integer, the number of iterations}

\item{B}{An integer, the length of the burn-in period}

\item{nprint}{An integer, the step number for printing the sampling progress}

\item{N}{An integer, the number (greater or equal one) of decision makers}

\item{Jm1}{An integer, one minus the number of choice alternatives (fixed across decision makers and choice occasions)}

\item{P_f}{An integer, the number of attributes that are connected to fixed coefficients (can be zero)}

\item{P_r}{An integer, the number of attributes that are connected to random, decision maker specific coefficients (can be zero)}

\item{C}{An integer, the number of latent classes (ignored if P_r = 0)}

\item{lcus}{A list, latent class updating scheme parameters}

\item{suff_statistics}{A list, sufficient statistics}

\item{prior}{A list, prior parameters}

\item{init}{A list, initial values for the Gibbs sampler}
}
\value{
A list of Gibbs samples
}
\description{
Routine to perform Gibbs sampling for the LCMMNP model
}
