% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raven_batch_detec.R
\name{raven_batch_detec}
\alias{raven_batch_detec}
\title{Run 'Raven' batch detector}
\usage{
raven_batch_detec(raven.path = NULL, sound.files, path = NULL, 
detector.type, detector.preset = "Default",
view.preset = "Default", relabel_colms = TRUE, pb = TRUE)
}
\arguments{
\item{raven.path}{A character string indicating the path of the directory in which to look for the 'Raven' executable file (where 'Raven' was installed).}

\item{sound.files}{character vector indicating the files that will be analyzed.
In OSX (mac) only one file at the time can be run (use loops instead!). If \code{NULL} (default) 
then 'Raven' will be run without opening any file.}

\item{path}{A character string indicating the path of the directory in which to look for
the sound files. If not provided (default) the function searches into the current working 
directory. Default is \code{NULL}.}

\item{detector.type}{Character string specifying the type of detector to be called.
There are 3 options available in 'Raven': 'Amplitude Detector', 'Band 
Limited Energy Detector' and 'Band Limited Entropy Detector'. Must be provided.}

\item{detector.preset}{Character string specifying the name of the customized detector to be called.
If \code{NULL} (default) then the 'Default' detector for the specific detector type is used 
(see 'detector.type' argument). Custom detectors must be found in one of the default 'Raven' detector directories 
(usually within "'raven.path'/Presets/Detector").}

\item{view.preset}{Character string specifying the name of the window preset to be used. Not require for 'Amplitude Detector' (see 'detector.type' argument).
If \code{NULL} (default) then the 'Default' window preset is used.}

\item{relabel_colms}{Logical. If  \code{TRUE} (default) colums are labeled to 
match the selection table format from the acoustic analysis package \code{\link{warbleR}}}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}
}
\value{
A data frame with the selections produced during the detection. See \code{\link{imp_raven}} for more details on how selections are imported.
}
\description{
\code{raven_batch_detec} Runs 'Raven' batch detector on multiple sound files sequentially
}
\details{
The function runs 'Raven' sound analysis software (Cornell Lab of
Ornithology), detector on  multiple sound files sequentially. 'Raven' Pro must be 
installed. Note that batch detection in 'Raven' can also take 
sound files in 'mp3', 'flac' and 'aif' format.
}
\examples{
\dontrun{

# here replace with the path where 'Raven' is install in your computer
raven.path <- "PATH_TO_RAVEN_DIRECTORY_HERE" 

# Run detector on raven example sound files

# single sound file using 'Amplitude Detector' 
detec.res <- raven_batch_detec(raven.path = raven.path, 
sound.files = "BlackCappedVireo.aif", path = file.path(raven.path, "Examples"), 
detector.type = "Amplitude Detector")

# on raven examples  2 files
detec.res <- raven_batch_detec(raven.path = raven.path, 
sound.files = c("BlackCappedVireo.aif", "CanyonWren.wav"), 
path = file.path(raven.path, "Examples"), detector.type = "Amplitude Detector")

# using 'Band Limited Energy Detector' 
detec.res <- raven_batch_detec(raven.path = raven.path, 
sound.files = c("BlackCappedVireo.aif", "CanyonWren.wav"), 
path = file.path(raven.path, "Examples"), detector = "Band Limited Energy Detector")
}

}
\seealso{
\code{\link{imp_raven}}; \code{\link{imp_syrinx}};  \code{\link{run_raven}}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
