% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_multivariate_corr_cov.R
\name{weighted.corr.cov.n}
\alias{weighted.corr.cov.n}
\title{Multivariate Correlation and Covariance}
\usage{
weighted.corr.cov.n(
  data,
  x,
  w = rep(1, length(data[x[1]])),
  corr = TRUE,
  na.rm = TRUE
)
}
\arguments{
\item{data}{(dataframe) data to analyze}

\item{x}{(vector string) variables names from where to get correlation/covariance}

\item{w}{(string) weight name}

\item{corr}{(bool) True: get correlation. False: get covariance}

\item{na.rm}{(bool) True: NAs be stripped before computation proceeds}
}
\value{
Dataframe containing 2 Choose length(x) columns with each bivariate correlation/covariance
}
\description{
Multivariate Correlation and Covariance
}
\examples{
data(df_talis18)

weighted.corr.cov.n(df_talis18,c("T3STAKE","T3TEAM","T3STUD"),"TCHWGT")

}
