% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulxR.R
\name{simulx}
\alias{simulx}
\title{Simulation of mixed effects models and longitudinal data}
\usage{
simulx(
  model = NULL,
  parameter = NULL,
  output = NULL,
  treatment = NULL,
  regressor = NULL,
  varlevel = NULL,
  group = NULL,
  project = NULL,
  nrep = 1,
  npop = NULL,
  fim = NULL,
  result.folder = NULL,
  result.file = NULL,
  stat.f = "statmlx",
  addlines = NULL,
  settings = NULL,
  data = NULL
)
}
\arguments{
\item{model}{a \code{Mlxtran} model used for the simulation. It can be a text file or an outut of the inLine function.
You can now create a new simulx project providing a model using \code{newProject} lixoft simulx connector.}

\item{parameter}{a vector of parameters with their names and values
You can now define a new individual element using \code{defineIndividualElement} lixoft simulx connector and
a new population element with 'definePopulationElement' lixoft simulx connector.}

\item{output}{a list (or list of lists) with fields:
\itemize{
\item \code{name}: a vector of output names
\item \code{time}: a vector of times (only for the longitudinal outputs)
\item \code{lloq}: lower limit of quantification (only for the longitudinal outputs)
\item \code{uloq}: upper limit of quantification (only for the longitudinal outputs)
\item \code{limit}: lower bound of the censoring interval (only for the longitudinal outputs)
}
You don't need to add individual parameters in output anymore since there are now automatically outputed.
You can now define a new output element using \code{defineOutputElement} lixoft simulx connector.}

\item{treatment}{a list with fields
\itemize{
\item \code{time} : a vector of input times,
\item \code{amount} : a scalar or a vector of amounts,
\item \code{rate} : a scalar or a vector of infusion rates (default=\code{Inf}),
\item \code{tinf} : a scalar or a vector of infusion times (default=0),
\item \code{type} : the type of input (default=1).
}
"target" field is not supported anymore in RsSimulx.
You can now define a new treatment element using \code{defineTreatmentElement} lixoft simulx connector.}

\item{regressor}{a list, or a list of lists, with fields
\itemize{
\item \code{name} : a vector of regressor names,
\item \code{time} : a vector of times,
\item \code{value} : a vector of values.
}
You can now define a new regressor element using \code{defineOccasionElement} lixoft simulx connector.}

\item{varlevel}{a list (or a dataframe) with fields:
\itemize{
\item \code{name} : name of the variable which defines the occasions,
\item \code{time} : a vector of times (beginnings of occasions)
}
You can now define occasion levels using \code{defineOccasionElement} lixoft simulx connector.}

\item{group}{a list, or a list of lists, with fields:
\itemize{
\item \code{size} : size of the group (default=1),
\item \code{parameter} : if different parameters per group are defined,
\item \code{output} : if different outputs per group are defined,
\item \code{treatment} : if different treatments per group are defined,
\item \code{regressor} : if different regression variables per group are defined.
}
"level" field is not supported anymore in RsSimulx.
You can now define a new simulation group using \code{addGroup} lixoft simulx connector and
use connectors \code{setGroupElement}, \code{setGroupSize}, to define groups attributes.}

\item{project}{the name of a Monolix project
You can now import all elements coming from a Monolix project to perform simulations
using \code{importMonolixProject} lixoft simulx connector.}

\item{nrep}{number of replicates
You can now define the number of replicates if the simulation using \code{setNbReplicates} lixoft simulx connector.}

\item{npop}{number of population parameters to draw randomly}

\item{fim}{a string with the Fisher Information Matrix to be used}

\item{result.folder}{the name of the folder where the outputs of simulx should be stored
\code{result.folder} argument is deprecated}

\item{result.file}{the name of the single file where the outputs of simulx should be saved}

\item{stat.f}{a R function for computing some summary (mean, quantiles, survival,...) of the simulated data. Default = "statmlx".
\code{stat.f} argument is deprecated}

\item{addlines}{a list with fields:
\itemize{
\item \code{formula}: string, or vector of strings, to be inserted .
}
"section", "block" field are not supported anymore in RsSimulx.
You only need to specify a formula. The additional lines will be added in a new section EQUATION.
You can now add lines to the model file using \code{setAddLines} lixoft simulx connector.}

\item{settings}{a list of optional settings
\itemize{
\item \code{seed} : initialization of the random number generator (integer) (by default a random seed will be generated)
\item \code{id.out}  : add (TRUE) / remove (FALSE) columns id and group when only one element (N = 1 or group = 1) (default=FALSE)
\item \code{kw.max} : maximum number of trials for generating a positive definite covariance matrix (default = 100)
\item \code{sep} : the field separator character (default = ",")
\item \code{digits} : number of decimal digits in output files (default = 5)
\item \code{replacement} : TRUE/FALSE (default = FALSE) sample id's with/without replacement
\item \code{out.trt} : TRUE/FALSE (default = TRUE) output of simulx includes treatment
}}

\item{data}{a list (output of simulx when settings$data.in==TRUE)
\code{data} argument is deprecated}
}
\value{
A list of data frames. Each data frame is an output of simulx
}
\description{
Compute predictions and sample data from \code{Mlxtran} and \code{R} models
}
\details{
simulx takes advantage of the modularity of hierarchical models for simulating
different components of a model: models for population parameters, individual
covariates, individual parameters and longitudinal data.

Furthermore, \code{simulx} allows to draw different types of longitudinal data,
including continuous, count, categorical, and time-to-event data.

The models are encoded using either the model coding language \samp{Mlxtran}.
\samp{Mlxtran} models are automatically converted into C++ codes,
compiled on the fly and linked to R using the \samp{RJSONIO} package.
That allows one to implement very easily complex models and to take advantage
of the numerical sovers used by the C++ \samp{mlxLibrary}.

See http://simulx.lixoft.com for more details.
}
\examples{
\dontrun{
myModel <- inlineModel("
[LONGITUDINAL]
input = {A, k, c, a}
EQUATION:
t0    = 0 
f_0   = A
ddt_f = -k*f/(c+f)
DEFINITION:
y = {distribution=normal, prediction=f, sd=a}
[INDIVIDUAL]
input = {k_pop, omega}
DEFINITION:
k = {distribution=lognormal, prediction=k_pop, sd=omega}
")
f <- list(name='f', time=seq(0, 30, by=0.1))
y <- list(name='y', time=seq(0, 30, by=2))
res <- simulx(model     = myModel, 
              parameter = c(A=100, k_pop=6, omega=0.3, c=10, a=2), 
              output    = list(f,y),
              group     = list(size=4))

plot(ggplotmlx() + geom_line(data=res$f, aes(x=time, y=f, colour=id)) +
     geom_point(data=res$y, aes(x=time, y=y, colour=id)))
print(res$parameter)
}

}
