% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eva_functions.R
\name{tsEvaComputeReturnPeriodsGEV}
\alias{tsEvaComputeReturnPeriodsGEV}
\title{tsEvaComputeReturnPeriodsGEV}
\usage{
tsEvaComputeReturnPeriodsGEV(epsilon, sigma, mu, BlockMax)
}
\arguments{
\item{epsilon}{The shape parameter of the GEV distribution.}

\item{sigma}{The scale parameter of the GEV distribution.}

\item{mu}{The location parameter of the GEV distribution.}

\item{BlockMax}{A vector containing the block maxima data.}
}
\value{
A list containing the following components:
\describe{
\item{\code{GevPseudo}}{A matrix of pseudo observations obtained from
the GEV distribution for each annual extreme at every time step.}
\item{\code{returnPeriods}}{A matrix of return periods corresponding to
the pseudo observations.}
\item{\code{PseudoObs}}{The pseudo observation corresponding to
the maximum value used in the computation.}
}
}
\description{
\code{tsEvaComputeReturnPeriodsGEV}is a function that computes the return
periods of a set of observations (can be Annual maxima or others)
for a Generalized Extreme Value (GEV)
distribution, given the GEV parameters and their standard error.
The return levels represent the values of annual maxima
with a certain probability, while the return periods indicate the average
time between exceedances of those threshold values.
}
\examples{

# Example usage with some sample data
epsilon <- 0.1
sigma <- 2.2
mu <- 1.3
BlockMax <- c(10, 20, 30, 40, 50)

results <- tsEvaComputeReturnPeriodsGEV(epsilon, sigma, mu, BlockMax)
head(results$GevPseudo)
head(results$returnPeriods)
head(results$PseudoObs)
}
\seealso{
\code{\link{empdis}}
}
