% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcgCreateKD.r
\name{vcgCreateKDtreeFromBarycenters}
\alias{vcgCreateKDtreeFromBarycenters}
\title{create a KD-tree from Barycenters for multiple closest point searches on a mesh}
\usage{
vcgCreateKDtreeFromBarycenters(mesh, nofPointsPerCell = 16,
  maxDepth = 64)
}
\arguments{
\item{mesh}{matrix or triangular mesh containing coordinates}

\item{nofPointsPerCell}{number of points per kd-cell}

\item{maxDepth}{maximum tree depth}
}
\value{
returns an object of class vcgKDtreeWithBarycenters containing external pointers to the tree, the barycenters and the target mesh
}
\description{
create a KD-tree from Barycenters for multiple closest point searches on a mesh
}
\examples{
\dontrun{
data(humface);data(dummyhead)
barytree <- vcgCreateKDtreeFromBarycenters(humface)
closest <- vcgClostOnKDtreeFromBarycenters(barytree,dummyhead.mesh,k=50,threads=1)
}
}
\seealso{
\code{\link{vcgClostOnKDtreeFromBarycenters}, \link{vcgSearchKDtree},  \link{vcgCreateKDtree}}
}
