% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rxSymInvChol}
\alias{rxSymInvChol}
\title{Get Omega^-1 and derivatives}
\usage{
rxSymInvChol(
  invObjOrMatrix,
  theta = NULL,
  type = "cholOmegaInv",
  thetaNumber = 0L
)
}
\arguments{
\item{invObjOrMatrix}{Object for inverse-type calculations.  If this is a matrix,
setup the object for inversion by \code{\link{rxSymInvCholCreate}} with the default arguments and return
a reactive s3 object.  Otherwise, use the inversion object to calculate the requested derivative/inverse.}

\item{theta}{Thetas to be used for calculation.  If missing (\code{NULL}), a
special s3 class is created and returned to access Omega^1
objects as needed and cache them based on the theta that is
used.}

\item{type}{The type of object.  Currently the following types are
    supported:
\itemize{
\item \code{cholOmegaInv} gives the
    Cholesky decomposition of the Omega Inverse matrix.
\item \code{omegaInv} gives the Omega Inverse matrix.
\item \code{d(omegaInv)} gives the d(Omega^-1) withe respect to the
    theta parameter specified in \code{thetaNumber}.
\item \code{d(D)} gives the d(diagonal(Omega^-1)) with respect to
    the theta parameter specified in the \code{thetaNumber}
    parameter
}}

\item{thetaNumber}{For types \code{d(omegaInv)} and \code{d(D)},
the theta number that the derivative is taken against.  This
must be positive from 1 to the number of thetas defining the
Omega matrix.}
}
\value{
Matrix based on parameters or environment with all the
    matrixes calculated in variables omega, omegaInv, dOmega,
    dOmegaInv.
}
\description{
Get Omega^-1 and derivatives
}
\author{
Matthew L. Fidler
}
