% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_S4_class_retro.R
\name{retrospective}
\alias{retrospective}
\alias{retrospective,Assessment-method}
\alias{retrospective,RCModel-method}
\title{Retrospective analysis of assessment models}
\usage{
retrospective(x, ...)

\S4method{retrospective}{Assessment}(x, nyr = 5, figure = TRUE)

\S4method{retrospective}{RCModel}(x, nyr = 5, figure = TRUE)
}
\arguments{
\item{x}{An S4 object of class \linkS4class{Assessment} of \linkS4class{RCModel}.}

\item{...}{More arguments.}

\item{nyr}{The maximum number of years to remove for the retrospective analysis.}

\item{figure}{Indicates whether plots will be drawn.}
}
\value{
A list with an array of model output and of model estimates from
the retrospective analysis.

Figures showing the time series of biomass and exploitation and parameter estimates
with successive number of years removed. For a variety of time series output (SSB, recruitment, etc.) and
estimates (R0, steepness, etc.), also returns a matrix of Mohn's rho (Mohn 1999).
}
\description{
Perform a retrospective analysis, successive removals of most recent years of data to evaluate resulting
parameter estimates.
}
\examples{
\donttest{
output <- SP(Data = swordfish)
get_retro <- retrospective(output, nyr = 5, figure = FALSE)
}
}
\references{
Mohn, R. 1999. The retrospective problem in sequential population analysis: an investigation using cod fishery
and simulated data. ICES Journal of Marine Science 56:473-488.
}
\author{
Q. Huynh
}
