% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_S4_class_RCModel.R
\name{plot.RCModel}
\alias{plot.RCModel}
\alias{plot,RCModel,missing-method}
\alias{compare_RCM}
\title{Plot RCM scope output}
\usage{
\S4method{plot}{RCModel,missing}(
  x,
  compare = FALSE,
  filename = "RCM",
  dir = tempdir(),
  sims = 1:x@OM@nsim,
  Year = NULL,
  f_name = NULL,
  s_name = NULL,
  MSY_ref = c(0.5, 1),
  bubble_adj = 1.5,
  scenario = list(),
  title = NULL,
  open_file = TRUE,
  quiet = TRUE,
  render_args,
  ...
)

compare_RCM(
  ...,
  compare = FALSE,
  filename = "compare_RCM",
  dir = tempdir(),
  Year = NULL,
  f_name = NULL,
  s_name = NULL,
  MSY_ref = c(0.5, 1),
  bubble_adj = 1.5,
  scenario = list(),
  title = NULL,
  open_file = TRUE,
  quiet = TRUE,
  render_args
)
}
\arguments{
\item{x}{An object of class \linkS4class{RCModel} (output from \link{RCM}).}

\item{compare}{Logical, if TRUE, the function will run \code{runMSE} to compare the historical period of the operating model
and the RCM output.}

\item{filename}{Character string for the name of the markdown and HTML files.}

\item{dir}{The directory in which the markdown and HTML files will be saved.}

\item{sims}{A logical vector of length \code{x@OM@nsim} or a numeric vector indicating which simulations to keep.}

\item{Year}{Optional, a vector of years for the historical period for plotting.}

\item{f_name}{Character vector for fleet names.}

\item{s_name}{Character vector for survey names.}

\item{MSY_ref}{A numeric vector for reference horizontal lines for B/BMSY plots.}

\item{bubble_adj}{A number to adjust the size of bubble plots (for residuals of age and length comps).}

\item{scenario}{Optional, a named list to label each simulation in the RCM for plotting, e.g.:
\code{list(names = c("low M", "high M"), col = c("blue", "red"))}.}

\item{title}{Optional character string for an alternative title for the markdown report.}

\item{open_file}{Logical, whether the HTML document is opened after it is rendered.}

\item{quiet}{Logical, whether to silence the markdown rendering function.}

\item{render_args}{A list of other arguments to pass to \link[rmarkdown]{render}.}

\item{...}{For \code{compare_RCM}, multiple RCM objects for comparison.}
}
\value{
Returns invisibly the output from \link[rmarkdown]{render}.
}
\description{
Produces HTML file (via markdown) figures of parameter estimates and output from an \linkS4class{Assessment} object.
Plots histograms of operating model parameters that are updated by the RCM scoping function, as well as diagnostic plots
for the fits to the RCM for each simulation. \code{compare_RCM} plots a short report that compares output from multiple RCM objects,
assuming the same model structure, i.e., identical matrix and array dimensions among models, but different data weightings, data omissions, etc.
}
\seealso{
\linkS4class{RCModel} \link{RCM}
}
