% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_table.R
\name{get_tables}
\alias{get_tables}
\title{Gets the available tables}
\usage{
get_tables(conn, pattern = NULL, show_temp = "never")
}
\arguments{
\item{conn}{An object that inherits from DBIConnection (as generated by get_connection())'}

\item{pattern}{A regex pattern with which to subset the returned tables}

\item{show_temp}{A string specifying how to handle temporary tables.
\itemize{
\item \code{"never"}, the default, will never return any temporary tables.
\item \code{"always"}, lists temporary tables as well as ordinary tables.
Note that this may return duplicate tables.
\item \code{"fallback"} lists temporary tables, but only if no ordinary table with the same name exists
}}
}
\value{
A data.frame containing table names in the DB
}
\description{
Gets the available tables
}
\examples{
conn <- get_connection(drv = RSQLite::SQLite())

dplyr::copy_to(conn, datasets::mtcars, name = DBI::Id(table = "my_test_table"))

get_tables(conn, pattern = "my_[th]est")
get_tables(conn, pattern = "my_[th]est", show_temp = "always")

close_connection(conn)
}
