% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_functions.R
\name{SDALGCPPred}
\alias{SDALGCPPred}
\title{Spatial prediction using plug-in of MCML estimates}
\usage{
SDALGCPPred(
  para_est,
  cellsize,
  continuous = TRUE,
  control.mcmc = NULL,
  pred.loc = NULL,
  divisor = 1,
  plot.correlogram = F,
  messages = TRUE,
  parallel = FALSE
)
}
\arguments{
\item{para_est}{an object of class "SDALGCP" obtained as a result of a call to \code{\link{SDALGCPMCML}}.}

\item{cellsize}{the size of the computational grid}

\item{continuous}{logical; to choose which prediction to do perform, discrete or continuous. the default is continuous.}

\item{control.mcmc}{output from \code{\link{controlmcmcSDA}}, if not provided, it uses the values used for the parameter estimation}

\item{pred.loc}{optional, the dataframe of the predictive grid.}

\item{divisor}{optional, the value to use to convert the dimension of the polygon, default is 1 which implies no conversion}

\item{plot.correlogram}{logical; if plot.correlogram=TRUE the autocorrelation plot of the conditional simulations is displayed.}

\item{messages}{logical; if messages=TRUE then status messages are printed on the screen (or output device) while the function is running. Default is messages=TRUE.}

\item{parallel}{to parallelize some part of the function.}
}
\value{
pred.draw: the samples of the prediction

pred: the prediction of the relative risk

predSD: the standard error of the prediction

Pred.loc: The coordinates of the predictive locations
}
\description{
This function performs spatial continuous and discrete prediction, fixing the model parameters at the Monte Carlo maximum likelihood estimates of a SDALGCP model.
}
\details{
The function perform prediction of the spatially discrete incidence and covariate adjusted relative risk, and spatially continuous relative risk. The discrete inference uses the Metropolis-Adjusted Langevin Hasting sampling from \code{\link{Laplace.sampling}}. And the continuous inference is typically change of support inference.
}
\examples{
### Prepare the input of the model
data(PBCshp)
data <- as.data.frame(PBCshp@data)  #get the data
### Write the formula of the model
FORM <- X ~ propmale + Income + Employment + Education + Barriers + Crime +
Environment +  offset(log(pop))
### set the discretised phi
phi <- seq(500, 1700, length.out = 20)
#### get the initial parameter
model <- glm(formula=FORM, family="poisson", data=data)
beta.start <-coef(model)
sigma2.start <- mean(model$residuals^2)
phi.start <- median(phi)
par0 <- c(beta.start, sigma2.start, phi.start)
# setup the control arguments for the MCMC
n <- 545
h <- 1.65/(n^(1/6))
control.mcmc <- controlmcmcSDA(n.sim = 10000, burnin = 2000,
                 thin= 8, h=h, c1.h = 0.01, c2.h = 1e-04)
###Run the model
\donttest{
my_est <- SDALGCPMCML(formula=FORM, data=data, my_shp=PBCshp, delta=100, phi=phi, method=1,
                     weighted=FALSE,  plot=TRUE, par0=par0, control.mcmc=control.mcmc)
Con_pred <- SDALGCPPred(para_est=my_est,  cellsize=300, continuous=TRUE)
}
}
\references{
Banerjee, S., Carlin, B. P., & Gelfand, A. E. (2014). Hierarchical modeling and analysis for spatial data. CRC press.
}
\seealso{
\link{plot.Pred.SDALGCP}, \link{SDAContinuousPred}, \link{SDADiscretePred}, \link{plot_continuous}, \link{plot_discrete}
}
\author{
Olatunji O. Johnson \email{o.johnson@lancaster.ac.uk}

Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
