\name{pickFields}
\alias{pickFields}
\title{Pick SEER fields of interest }
\description{ This function truncates the full set of SEER data fields into a smaller set of interest.}
\usage{pickFields(sas,picks)} 

\arguments{
  \item{sas}{ A data frame created by \code{getFields()} using the SAS file found in 
  the \file{incidence} directory of \code{seerHome}, the root of the SEER ASCII data installation.}
  \item{picks}{ Vector of names of variables of interest. These must be in the same order as found in the 
  input data frame \code{sas}.
The default is \code{picks=c("casenum","reg","race",} 
\code{"sex","agedx","yrbrth","seqnum","yrdx","histo2","histo3","radiatn",}
\code{"agerec","ICD9","histrec","numprims","COD","surv")}
  }
}
\details{R binaries become too large if all of the fields are selected. \code{SEERaBomb} is faster than SEER*Stat 
because it tailors/streamlines the database to your interests.}

\value{The SAS-based input data frame \code{sas}, shortened to just the rows of \code{picks}, and then expanded to include 
spacer rows of fields of no interest pooled into single strings: the width of such a spacer row is equal to 
the distance in bytes between the fields of interest above and below it. This data frame is then 
used by \code{laf_open_fwf()} of \pkg{LaF} in \code{mkSEER()} to read the SEER files. It is made visible to users to allow checking of 
their choices. Proper use of this function, and of the SEER data in general,
requires an understanding of the contents of \file{seerdic.pdf} in the \file{incidence} directory of \code{seerHome}.
}

\note{ This work was supported by the National Cancer Institute and Tufts Integrative 
        Cancer Biology Program under U54CA149233-029689. }
\author{Tom Radivoyevitch (txr24@case.edu)}
\seealso{\code{\link{SEERaBomb-package}, \link{getFields}, \link{pickFields}, \link{mkSEER}} }
\examples{
\dontrun{
library(SEERaBomb)
(df=getFields())
(df=pickFields(df))

}
}
\keyword{IO}
