% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SEHmodel-package.R
\docType{package}
\encoding{UTF-8}
\name{SEHmodel-package}
\alias{SEHmodel}
\alias{SEHmodel-package}
\title{Spatial Exposure-Hazard Model for Exposure and Impact Assessment on Exposed Individuals}
\description{
A model coupling polygon and point processes for assessing risk due to contaminant sources and their impact on exposed individuals
}
\details{
\tabular{ll}{
         Package: \tab SEHmodel\cr
         Type: \tab Package\cr
         Version: \tab 0.0.9\cr
         Date: \tab 2015-10-02\cr
         License: \tab GPL (>=2)\cr
         }

The SEHmodel package contains functions and methods for quantifying spatio-temporal variation in contamination risk
around known polygon sources of contaminants, and quantifies the impact of the contaminants on the surrounding population of individuals
which are located in habitat areas and are susceptible to the contaminants.

The package implements an exposure-hazard model based on (i) tools of stochastic geometry (marked polygon and point processes)
for structuring the landscape and describing the location of exposed individuals,
(ii) a method based on a dispersal kernel describing the dissemination of contaminant particles from polygon sources,
and (iii) an ecotoxicological equation describing how contaminants affect individuals of the exposed population.
}
\examples{
## Run a simulation
\dontrun{
library("SEHmodel")
demo.pollen.run()
}
}
\author{
Melen Leclerc \email{melen.leclerc@rennes.inra.fr}

Jean-Francois Rey \email{jean-francois.rey@paca.inra.fr}

Samuel Soubeyrand \email{Samuel.Soubeyrand@avignon.inra.fr}

Emily Walker \email{emily.walker@avignon.inra.fr}

Marc Bourotte \email{marc.bourotte@avignon.inra.fr}
}
\references{
Emily Walker and al. , SEHmodel: Spatially-explicit model for exposure and impact assessment
}
\seealso{
\code{\link{demo.pollen.run}}
}
\keyword{model}
\keyword{spatial}
\keyword{survival}

