% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{createIdentifierBaseCase}
\alias{createIdentifierBaseCase}
\title{Create an identifier base case}
\usage{
createIdentifierBaseCase(L, O)
}
\arguments{
\item{L}{Adjacency matrix for the directed part of the path
diagram/mixed graph; an edge pointing from i to j is encoded as L[i,j]=1 and
the lack of an edge between i and j is encoded as L[i,j]=0. There should be
no directed self loops, i.e. no i such that L[i,i]=1.}

\item{O}{Adjacency matrix for the bidirected part of the path diagram/mixed
graph. Edges are encoded as for the L parameter. Again there should be no
self loops. Also this matrix will be coerced to be symmetric so it is only
necessary to specify an edge once, i.e. if O[i,j]=1 you may, but are not
required to, also have O[j,i]=1.}
}
\value{
a function that takes as input a covariance matrix compatible with
        the mixed graph defined by L/O and returns a list with two
        named components:
        Lambda - a matrix equal to L but with NA values instead of 1s,
        Omega - a matrix equal to O but with NA values instead of 1s.
        When building more complex identifiers these NAs will be replaced
        by the value that can be identified from Sigma.
}
\description{
Identifiers are functions that take as input a covariance matrix Sigma
corresponding to some mixed graph G and, from that covariance matrix,
identify some subset of the coefficients in the mixed graph G. This function
takes as input the matrices, L and O, defining G and creates an identifier
that does not identify any of the coefficients of G. This is useful as a
base case when building more complex identification functions.
}
