% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semCluster.R
\name{mergeNodes}
\alias{mergeNodes}
\title{Graph nodes merging by a user-defined membership attribute}
\usage{
mergeNodes(graph, membership, HM, ...)
}
\arguments{
\item{graph}{Network as an igraph object.}

\item{membership}{Cluster membership. A vector of cluster membership
identifiers, where vector names correspond to graph node names.
Topological graph clustering can be done using
\code{\link[SEMgraph]{clusterGraph}}.}

\item{HM}{Hidden model label. If HM = "LV", a latent variable (LV)
will be defined as common unknown cause acting on cluster nodes.
If HM = "CV", cluster nodes will be considered as regressors of a
latent composite variable (CV). Finally, if HM = "UV", an unmeasured
variable (UV) is defined, where source nodes of the module (i.e.,
in-degree = 0) act as common regressors influencing the other nodes
via an unmeasured variable.}

\item{...}{Currently ignored.}
}
\value{
A network with merged nodes as an igraph object.
}
\description{
Merge groups of graph nodes using a custom membership
attribute (e.g., cluster membership).
}
\examples{

# Clustering ALS graph with WTC method
G <- properties(alsData$graph)[[1]]
membership <- clusterGraph(graph = G, type = "wtc")
M <- mergeNodes(G, membership, HM = "LV")

}
\seealso{
\code{\link[SEMgraph]{clusterGraph}}
}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
