% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plinearpool.R
\name{plinearpool}
\alias{plinearpool}
\alias{qlinearpool}
\title{Calculate fitted probabilities or quantiles from a (weighted) linear pool}
\usage{
plinearpool(fit, x, d = "best", w = 1)
qlinearpool(fit, q, d = "best", w = 1)
}
\arguments{
\item{fit}{The output of a \code{fitdist} command.}

\item{x}{A vector of required cumulative probabilities P(X<=x)}

\item{d}{Scalar or vector of distributions to use for each expert.
Options for each vector element are \code{"hist"}, \code{"normal"}, \code{"t"},
\code{"gamma"}, \code{"lognormal"}, \code{"logt"},\code{"beta"},
\code{"best"}. If given as a scalar, same choice is used for all experts.}

\item{w}{A vector of weights to be used in the weighted linear pool.}

\item{q}{A vector of required quantiles}
}
\value{
A probability or quantile, calculate from a (weighted) linear pool
(arithmetic mean) of the experts' individual fitted probability.
}
\description{
Calculates a linear pool given a set of elicited judgements in a \code{fit}
object. Then calculates required probabilities or quantiles from the pooled
cumulative distribution function.
}
\details{
Quantiles are calculate by first calculating the pooled cumulative
distribution function at 100 points, and then using linear interpolation to
invert the CDF.
}
\examples{
\dontrun{
# Expert 1 states P(X<30)=0.25, P(X<40)=0.5, P(X<50)=0.75
# Expert 2 states P(X<20)=0.25, P(X<25)=0.5, P(X<35)=0.75
# Both experts state 0<X<100.

v <- matrix(c(30, 40, 50, 20, 25, 35), 3, 2)
p <- c(0.25, 0.5, 0.75)
myfit <- fitdist(vals = v, probs = p, lower = 0, upper = 100)

plinearpool(myfit, x=c(20, 50, 80))
qlinearpool(myfit, q=c(0.05, 0.5, 0.95))

# give more weight to first expert
plinearpool(myfit, x=c(20, 50, 80), w=c(0.7, 0.3)) 

# force the use of gamma distributions for each expert
qlinearpool(myfit, q=c(0.05, 0.5, 0.95), d="gamma") 
}
}
\author{
Jeremy Oakley <j.oakley@sheffield.ac.uk>
}
