% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov2.2012LC.R
\name{cov2.2012LC}
\alias{cov2.2012LC}
\title{Two-sample Test for High-Dimensional Covariances by Li and Chen (2012)}
\usage{
cov2.2012LC(X, Y, unbiased = FALSE)
}
\arguments{
\item{X}{an \eqn{(n_x \times p)} data matrix of 1st sample.}

\item{Y}{an \eqn{(n_y \times p)} data matrix of 2nd sample.}

\item{unbiased}{a logical; \code{FALSE} to use biased estimator with faster speed, \code{TRUE} otherwise.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given two multivariate data \eqn{X} and \eqn{Y} of same dimension, it tests
\deqn{H_0 : \Sigma_x = \Sigma_y\quad vs\quad H_1 : \Sigma_x \neq \Sigma_y}
using the procedure by Li and Chen (2012). In accordance with a proposal 
by authors, we offer an option to use biased estimator instead for faster computation.
}
\examples{
## CRAN-purpose small example
smallX = matrix(rnorm(10*3),ncol=3)
smallY = matrix(rnorm(10*3),ncol=3)
cov2.2012LC(smallX, smallY) # run the test

\dontrun{
## comparison of biased and unbiased estimator
## empirical Type 1 error 
niter   = 100
vec.slow = rep(0,niter)  # record p-values
vec.fast = rep(0,niter)
for (i in 1:niter){
  X = matrix(rnorm(500*25), ncol=10)
  Y = matrix(rnorm(500*25), ncol=10)
  
  vec.slow[i] = ifelse(cov2.2012LC(X,Y,unbiased=TRUE)$p.value  < 0.05,1,0)
  vec.fast[i] = ifelse(cov2.2012LC(X,Y,unbiased=FALSE)$p.value < 0.05,1,0)
}

## print the result
cat(paste("\n* EMPIRICAL TYPE 1 ERROR COMPARISON \n","*\n",
"* Biased   case : ", round(sum(vec.fast/niter),5),"\n",
"* Unbiased case : ", round(sum(vec.slow/niter),5),"\n",sep=""))
}

}
\references{
\insertRef{li_two_2012}{SHT}
}
\concept{covariance}
