% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meank_2009ZX.R
\name{meank.2009ZX}
\alias{meank.2009ZX}
\title{Test for Equality of Means by Zhang and Xu (2009)}
\usage{
meank.2009ZX(dlist, method = c("L", "T"))
}
\arguments{
\item{dlist}{a list of length \eqn{k} where each element is a sample matrix of same dimension.}

\item{method}{a method to be applied for the transformed problem. \code{"L"} for \eqn{L^2}-norm based method, and 
\code{"T"} for Hotelling's test, which might fail due to dimensionality. Case insensitive.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given univariate samples \eqn{X_1~,\ldots,~X_k}, it tests
\deqn{H_0 : \mu_1 = \cdots \mu_k\quad vs\quad H_1 : \textrm{at least one equality does not hold}}
using the procedure by Zhang and Xu (2009) by applying multivariate extension of Scheffe's method 
of transformation.
}
\examples{
## CRAN-purpose small example
tinylist = list()
for (i in 1:3){ # consider 3-sample case
  tinylist[[i]] = matrix(rnorm(10*3),ncol=3)
}
meank.2009ZX(tinylist) # run the test

\donttest{
## test when k=5 samples with (n,p) = (100,20)
## empirical Type 1 error 
niter   = 1000
counter = rep(0,niter)  # record p-values
for (i in 1:niter){
  mylist = list()
  for (j in 1:5){
     mylist[[j]] = matrix(rnorm(100*10),ncol=10)
  }
  
  counter[i] = ifelse(meank.2009ZX(mylist, method="L")$p.value < 0.05, 1, 0)
}

## print the result
cat(paste("\n* Example for 'meank.2009ZX'\n","*\n",
"* number of rejections   : ", sum(counter),"\n",
"* total number of trials : ", niter,"\n",
"* empirical Type 1 error : ",round(sum(counter/niter),5),"\n",sep=""))
}


}
\references{
\insertRef{zhang_ksample_2009}{SHT}
}
\concept{mean_multivariate}
