% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.SIR.R
\name{plot.SIR}
\alias{plot.SIR}
\title{Graphical output of SIR}
\usage{
\method{plot}{SIR}(x, choice = "", ...)
}
\arguments{
\item{x}{A SIR object}

\item{choice}{the graph to plot: 
\itemize{
  \item "eigvals" Plot the eigen values of the matrix of interest.
  \item "estim_ind" Plot the estimated index by the SIR model versus Y.
  \item "" Plot every graphs (default).
}}

\item{\ldots}{arguments to be passed to methods, such as graphical parameters (not used here).}
}
\value{
No return value
}
\description{
Display the 10 first eigen values and the estimated index versus Y of the SIR model.
}
\examples{
# Generate Data
set.seed(10)
n <- 500
beta <- c(1,1,rep(0,8))
X <- mvtnorm::rmvnorm(n,sigma=diag(1,10))
eps <- rnorm(n)
Y <- (X\%*\%beta)**3+eps

# Apply SIR
res = SIR(Y, X, H = 10, graph = FALSE)

# Eigen values
plot(res,choice="eigvals")

# Estimated index versus Y
plot(res,choice="estim_ind")
}
