% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skriging.R
\name{skriging}
\alias{skriging}
\alias{print.skriging}
\alias{plot.skriging}
\title{Function for Segment-based Kriging models}
\usage{
skriging(formula, polyline = polyline, method = "srk",
          lwd = "width", obspred = "obs1pred0", boxcox = TRUE)
\method{print}{skriging}(x, ...)
\method{plot}{skriging}(x, studyarea = NULL, ...)
}
\arguments{
\item{formula}{A skriging formula.}

\item{polyline}{A shapefile of spatial polyline.}

\item{method}{A characteor of segment-based Kriging model. The default is "srk",
segment-based regression Kriging Another method is "sok", segment-based ordinary
Kriging.}

\item{lwd}{A fixed number or a variable name of polyline of the line width.}

\item{obspred}{A variable name of polyline to define the observation and prediction lines.
Observation is 1 and prediction is 0.}

\item{boxcox}{A logical parameter to set whether the dependent variable should be transformed
with boxcox function. The default is TRUE.}

\item{x}{A list of \code{skriging} result.}

\item{studyarea}{A shapefile of spatial polygon of study area.}

\item{...}{new print and plot}
}
\description{
Segment-based Kriging models, including Segment-based Ordinary Kriging (SOK) and
Segment-based Regression Kriging (SRK), for spatial prediction of
line segment spatial data (polyline). The methods are described in
Yongze Song (2018) <doi:10.1109/TITS.2018.2805817>.
}
\examples{
## SRK: segment-based regression Kriging
## dataset 'vtest' is a sample of dataset 'vehicles'
srk1 <- skriging(heavy ~ wpai + width, polyline = vtest, method = "srk",
                 lwd = "width", obspred = "obs1pred0", boxcox = TRUE)
srk1
plot(srk1)

}
