% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SLCARE.R
\name{SLCARE}
\alias{SLCARE}
\title{Semiparametric Latent Class Analysis for Recurrent Event}
\usage{
SLCARE(
  alpha = NULL,
  beta = NULL,
  dat,
  K = NULL,
  gamma = 0,
  max_epoches = 500,
  conv_threshold = 0.01,
  boot = NULL
)
}
\arguments{
\item{alpha}{initial values for alpha for estimation procedure. This should be NULL or a numberic matirx. NULL means obtain initial value with k-means.}

\item{beta}{initial value for beta for estimation procedure. This should be NULL or a numberic matirx. NULL means obtain initial value with k-means.}

\item{dat}{a data frame containing the data in the model}

\item{K}{number of latent classes}

\item{gamma}{individual frailty. 0 represents the frailty equals 1 and k represents the frailty follows gamma(k,k)}

\item{max_epoches}{maximum iteration epoches for estimation procedure}

\item{conv_threshold}{converge threshold for estimation procedure}

\item{boot}{bootstrap sample size}
}
\value{
A list containing the following components:
\describe{
\item{alpha}{Point estimates for alpha}
\item{beta}{Point estimates for beta}
\item{convergeloss}{Converge loss in estimation procedure}
\item{PosteriorPrediction}{Posterior prediction for observed events for subjects of interest}
\item{EstimatedTau}{Posterior probability of latent class membership}
\item{ModelChecking}{Plot for model checking}
\item{Estimated_mu0t}{Plot for estimated mu0(t)}
\item{est_mu0()}{A function allows to calculate mu0(t) for specific time points}
\item{Estimated_Mean_Function}{Plot of estimated mean functions}
\item{RelativeEntropy}{Relative entropy}
\item{InitialAlpha}{Initial alpha for estimation procedure}
\item{InitialBeta}{Initial beta for estimation procedure}
}
If argument 'boot' is non-NULL, then SLCARE returns two additional components:
\describe{
\item{alpha_bootse}{Bootstrap standard error for alpha}
\item{beta_bootse}{Bootstrap standard error for beta}
}
}
\description{
Conduct Semiparametric Latent Class Analysis for Recurrent Event.
}
\examples{
data(SLCARE_simdat)
# Example 1: number of latent classes k = 2,
# By default, generate initial values in estimation procedure with K-means
model1 <- SLCARE(dat = SLCARE_simdat, K=2)
# contents of output
names(model1)
# point estimates
model1$alpha
model1$beta
# converge loss in estimation procedure
model1$convergeloss
# Posterior prediction
model1$PosteriorPrediction
# Posterior probability of latent class membership
model1$EstimatedTau
# model checking plot
model1$ModelChecking
# Plot of estimated \eqn(\mu_0 (t)) for all observed time
model1$Estimated_mu0t
# Estimated \eqn(\mu_0 (t))
# You may input multiple time points of interest
model1$est_mu0(c(100, 1000, 5000))
# Plot of estimated mean function
model1$Estimated_Mean_Function
# Relative entropy
model1$RelativeEntropy
# Initial values for estimation procedure
model1$InitialAlpha
model1$InitialBeta
# You can select initial value in estimation procedure manually
# alpha <- matrix(c(0, 0, 0.5, -2, 2, -4),
#                 nrow = 3, ncol = 2, byrow = TRUE)
# beta <- matrix(c(2.5, -0.5, -0.3, 1.5, -0.2, -0.5,
#                   2.5,  0.1, 0.2), nrow = 3 , ncol = 2+1 , byrow = TRUE)
# model2 <- SLCARE(alpha, beta, dat = SLCARE_simdat)
# You can define individual frailty with gamma(p,p).
# Below is an example with manually defined initial value and frailty gamma(3,3)
# model3 <- SLCARE(alpha, beta, dat = SLCARE_simdat, gamma = 3)
# You can use bootstrap for bootstrap standard error.
# Bootstrap sample size = 100 (time consuming procedure)
# model4 <- SLCARE(alpha, beta, dat = SLCARE_simdat, boot = 100)
# SLCARE() with "boot" argument will return to two additional contents:
# "alpha_bootse", "beta_bootse" which are Bootsrap standard errors.
# model4$alpha_bootse
# model4$beta_bootse
}
