% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SLICER.R
\name{cell_order}
\alias{cell_order}
\title{Sort cells according to their progress through a process}
\usage{
cell_order(traj_graph, start)
}
\arguments{
\item{traj_graph}{Nearest neighbor graph built from LLE embedding}

\item{start}{Index of starting cell}
}
\value{
Sorted vector of cell indices
}
\description{
Uses the values computed by \code{process_distance} to order cells.
}
\examples{
genes=1:200
cells=sample(1:500,30)
data(traj)
k=10
traj_lle = lle::lle(traj[cells,genes],m=2,k)$Y
traj_graph = conn_knn_graph(traj_lle,5)
start=1
cells_ordered = cell_order(traj_graph,start)
}
