% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_direction_Dopt.R
\name{plot_direction_Dopt}
\alias{plot_direction_Dopt}
\title{Verify the optimality condition for the D-optimal design}
\usage{
plot_direction_Dopt(u, design, tt, FUN, theta)
}
\arguments{
\item{u}{The discretized design points.}

\item{design}{The D-optimal design that contains the design points and the associated weights.}

\item{tt}{The level of skewness.}

\item{FUN}{The function to calculate the derivative of the given model.}

\item{theta}{The parameter value of the model.}
}
\value{
The plot of the negative value of the directional derivative of a D-optimal design
}
\description{
Verify the optimality condition for the D-optimal design
}
\details{
This function produces the figure for the negative value of the directional derivative of the given D-optimal design of the compact supports. According to the general equivalence theorem, for an optimal design, all the directional derivative should be below zero line.
}
\examples{
poly3 <- function(xi, theta){
    matrix(c(1, xi, xi^2, xi^3), ncol = 1)
}
design = data.frame(location = c(-1, -0.447, 0.447, 1),
 weight = rep(0.25, 4))
u = seq(-1, 1, length.out = 201)
plot_direction_Dopt(u, design, tt=0, FUN = poly3,
  theta = rep(0, 4))


}
