% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqtl_funcs.R
\name{findGenomicPos}
\alias{findGenomicPos}
\title{Query GTEx portal for Variant's genomic position based on rsID
Retrieves variant information from the GTEx portal using either
an rsID or a variant ID formatted as \code{CHR_POS_REF_ALT}.
If an rsID is provided, the function returns the corresponding
genomic positions in both GRCh37 and GRCh38 builds.
When searching for an rsID based on genomic position, the position
parameter should be specified according to the GRCh38 reference genome.}
\usage{
findGenomicPos(id, type = "rsid", file_path = NULL)
}
\arguments{
\item{id}{Character string representing the rsID (e.g., \code{"rs12345"}) or the variant ID
in the format \code{"CHR_POS_REF_ALT"} (e.g., \code{"1_1234567_A_T"}), depending on \code{type}.}

\item{type}{Character string specifying the type of query. Must be either \code{"rsid"} or \code{"varid"}.}

\item{file_path}{character, path to a file for saving results as Excell spreadsheet.}
}
\value{
A \code{data.table} containing variant information including:
\itemize{
\item \code{rsid}: variant id in rsID format
\item \code{chromosome}: chromosome number
\item \code{position_b37}: genomic position
\item \code{position_b38}: genomic position
\item \code{ref}: reference allele
\item \code{alt}: alternate allele
}
}
\description{
Query GTEx portal for Variant's genomic position based on rsID
Retrieves variant information from the GTEx portal using either
an rsID or a variant ID formatted as \code{CHR_POS_REF_ALT}.
If an rsID is provided, the function returns the corresponding
genomic positions in both GRCh37 and GRCh38 builds.
When searching for an rsID based on genomic position, the position
parameter should be specified according to the GRCh38 reference genome.
}
