% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_incurred.R
\name{output_incurred}
\alias{output_incurred}
\title{Incurred Triangles}
\usage{
output_incurred(
  incurred_history,
  aggregate_level = 1,
  incremental = TRUE,
  future = TRUE
)
}
\arguments{
\item{incurred_history}{the full history of incurred case estimates, see
\code{\link{claim_history}}.}

\item{aggregate_level}{number of periods to be aggregated together; must be
a divisor of the total number of periods under consideration (default 1).}

\item{incremental}{logical; if true returns the incremental incurred square,
else returns the cumulative incurred square.}

\item{future}{logical; if true (default) shows the full claim triangle (i.e.
including claim payments in future periods), else shows only the past
triangle.}
}
\value{
An array of claims incurred to date.
}
\description{
Outputs the full square of claims incurred by occurrence period and
development period. The upper left triangle represents the past, and the
lower right triangle the unseen future. \cr \cr
Users can modify the aggregate level by providing an \code{aggregate_level}
argument to the function. For example, setting \code{aggregate_level = 4} when
working with calendar \emph{quarters} produces an incurred square by occurrence
and development \emph{year}. \cr \cr
We refer to the package vignette for examples on changing the aggregation
granularity:
\code{vignette("SPLICE-demo", package = "SPLICE")}
}
\details{
\strong{Remark on out-of-bound transaction times}: This function includes
adjustment for out-of-bound transaction dates, by forcing any transactions
that were projected to fall out of the maximum development period to be
counted as if they were made at the end of the limiting development period.
For example, if we consider 40 periods of development and a claim of the 21st
occurrence period was projected to have a major revision at time 62.498210,
then we would treat such a revision as if it occurred at time 60 for the
purpose of tabulation.
}
