% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlrTools.R
\name{getMlrTask}
\alias{getMlrTask}
\title{Generate an mlr task from Census KDD data set (+variation)}
\usage{
getMlrTask(dataset, task.type = "classif", data.seed = 1)
}
\arguments{
\item{dataset}{census data set}

\item{task.type}{character, either "classif" or "regr".}

\item{data.seed}{seed}
}
\value{
an mlr task with the respective data set. Generated with
\code{\link[mlr]{makeClassifTask}} or
\code{\link[mlr]{makeRegrTask}} for
classification and regression repectively.
}
\description{
Prepares the Census data set for mlr.
Performs imputation via: \code{factor = imputeMode()},
\code{integer = imputeMedian()},
\code{numeric = imputeMean()}
}
\examples{
\donttest{
## Example downloads OpenML data, might take some time:
x <- getDataCensus(
task.type="classif",
nobs = 1e3,
nfactors = "high",
nnumericals = "high",
cardinality = "high",
data.seed=1,
cachedir= "oml.cache",
target = "age")

taskdata <- getMlrTask(
dataset = x,
task.type = "classif",
data.seed = 1)
}
}
\seealso{
\code{\link{getDataCensus}}
}
