% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlrTools.R
\name{prepare_data_plot}
\alias{prepare_data_plot}
\title{Prepare data for plots}
\usage{
prepare_data_plot(
  model = buildRanger,
  modelControl = list(),
  x,
  namesx = paste("x", 1:ncol(x), sep = ""),
  y,
  namesy = "y",
  log = NULL,
  nameslog = NULL
)
}
\arguments{
\item{model}{a function that can be used to build a model based on the data, e.g. : \code{buildRanger} or \code{buildKriging}. Default is \code{buildRanger}, since it is fast and robust.}

\item{modelControl}{a list of control settings for the respective model. Default is an empty list (use default model controls).}

\item{x}{a matrix of x-values to be plotted (i.e., columns are the independent variables, rows are samples). Should have same number of rows as y and log.}

\item{namesx}{character vector, printable names for the x data. Should have same length as x has columns. Default is x1, x2, ...}

\item{y}{a one-column matrix of y-values to be plotted (dependent variable). Should have same number of rows as x and log.}

\item{namesy}{character, giving a printable name for y. Default is "y".}

\item{log}{matrix, a data set providing (optional) additional dependent variables (but these are not modeled). Should have same number of rows as y and x.}

\item{nameslog}{character vector, printable names for the log data. Should have same length as log has columns. Default is NULL (no names).}
}
\value{
list with plotting data and information
}
\description{
mlrTools
}
