% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_funcs.R
\name{createPeaksFilter}
\alias{createPeaksFilter}
\title{Genrate a peak filter object.}
\usage{
createPeaksFilter(peaksIndices)
}
\arguments{
\item{peaksIndices}{a named array representing the selected peaks. Names correspond
to the m/z values.}
}
\value{
\code{peak.filter} object.
}
\description{
\link{createPeaksFilter} returns a \code{peak.filter} object.
}
\details{
Function to create a custom peak that can be subsequently applied using
the function \code{\link{applyPeaksFilter-msi.dataset-method}}. Argument of
the function is the index vector of the selected peaks named with their m/z
values. M/Z values are used to check whether the indices correspond to the
matched m/z values in the \code{\link{msi.dataset-class}} object.
}
\examples{
library("SPUTNIK")
mz <- seq(100, 195, 5)
mzIdx <- sample(100, 20)
names(mzIdx) <- mz
peaksFilter <- createPeaksFilter(mzIdx)

}
\seealso{
\link{applyPeaksFilter-msi.dataset-method}
}
\author{
Paolo Inglese \email{p.inglese14@imperial.ac.uk}
}
