% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPlit.R
\name{splitratio}
\alias{splitratio}
\title{Optimal splitting ratio}
\usage{
splitratio(x, y, method = "simple", degree = 2)
}
\arguments{
\item{x}{Input matrix}

\item{y}{Response (output variable)}

\item{method}{This could be “simple” or “regression”. The default method “simple” uses the square root of the number of unique rows in \code{x} as the number of parameters, whereas “regression” estimates the number of parameters using stepwise regression. The “regression” method works only with continuous output variable.}

\item{degree}{This specifies the degree of the polynomial to be fitted, which is needed only if \code{method}=“regression” is used. Default is 2.}
}
\value{
Splitting ratio, which is the fraction of the dataset to be used for testing.
}
\description{
\code{splitratio()} finds the optimal splitting ratio by assuming a polynomial regression model with interactions can approximate the true model. The number of parameters in the model is estimated from the full data using stepwise regression. A simpler solution is to choose the number of parameters to be square root of the number of unique rows in the input matrix of the dataset. Please see Joseph (2022) for details.
}
\examples{
X = rnorm(n=100, mean=0, sd=1) 
Y = rnorm(n=100, mean=X^2, sd=1)
splitratio(x=X, y=Y)
splitratio(x=X, y=Y, method="regression")

}
\references{
Joseph, V. R. (2022). Optimal Ratio for Data Splitting. Statistical Analysis & Data Mining: The ASA Data Science Journal, to appear.
}
