#' CheckM reference markers for Prokaryotes
#'
#' List of Universal Single Copy Genes for Bacteria and Archaea.
#'
#' @docType data
#'
#' @usage data(CheckMProkaryote)
#'
#' @format List containing vectors of PFAMs, each vector corresponding to a different set of collocated markers.
#'
#' @keywords datasets
#'
#' @references Parks, Imelfort, Skennerton, Hugenholtz & Tyson (2015). 
#' CheckM: assessing the quality of microbial genomes recovered from isolates, single cells, and metagenomes
#' \emph{Genome Res.} \bold{25}:1043-1055.
#' (\href{https://pubmed.ncbi.nlm.nih.gov/25977477/}{PubMed}).
#'
#'
#' @seealso \code{\link{USiCGs}}, \code{\link{MGOGs}} and \code{\link{MGKOs}} for an alternative set of single copy genes, and for examples on how to generate copy numbers.
#'
#'
"CheckMProkaryote"
