% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HierarchyCompute.R
\name{DummyHierarchy}
\alias{DummyHierarchy}
\title{Converting hierarchy specifications to a (signed) dummy matrix}
\usage{
DummyHierarchy(mapsFrom, mapsTo, sign, level, mapsInput = NULL,
  inputInOutput = FALSE, keepCodes = mapsFrom[integer(0)],
  unionComplement = FALSE)
}
\arguments{
\item{mapsFrom}{Character vector from hierarchy table}

\item{mapsTo}{Character vector from hierarchy table}

\item{sign}{Numeric vector of either 1 or -1 from hierarchy table}

\item{level}{Numeric vector from hierarchy table}

\item{mapsInput}{All codes in mapsTo not in mapsFrom (created automatically when NULL) and possibly other codes in input data.}

\item{inputInOutput}{When FALSE all output rows represent codes in mapsTo}

\item{keepCodes}{To prevent some codes to be removed when inputInOutput = TRUE}

\item{unionComplement}{When TRUE, sign means union and complement instead of addition or subtraction (see note)}
}
\value{
A sparse matrix with row and column and names
}
\description{
A matrix for mapping input codes (columns) to output codes (rows) are created.
}
\details{
The elements of the matrix specify how columns contribute to rows.
}
\note{
With unionComplement = FALSE (default), the sign of each mapping specifies the contribution as addition or subtraction.
Thus, values above one and negative values in output can occur.
With unionComplement = TRUE,  positive is treated as union and negative as complement. Then 0 and 1 are the only possible elements in the output matrix.
}
\examples{
# A hierarchy table
h <- SSBtoolsData("FIFA2018ABCD")

DummyHierarchy(h$mapsFrom, h$mapsTo, h$sign, h$level)
DummyHierarchy(h$mapsFrom, h$mapsTo, h$sign, h$level, inputInOutput = TRUE)
DummyHierarchy(h$mapsFrom, h$mapsTo, h$sign, h$level, keepCodes = c("Portugal", "Spain"))

# Extend the hierarchy table to illustrate the effect of unionComplement
h2 <- rbind(data.frame(mapsFrom = c("EU", "Schengen"), mapsTo = "EUandSchengen", 
                       sign = 1, level = 3), h)

DummyHierarchy(h2$mapsFrom, h2$mapsTo, h2$sign, h2$level)
DummyHierarchy(h2$mapsFrom, h2$mapsTo, h2$sign, h2$level, unionComplement = TRUE)

#' # Extend mapsInput - leading to zero columns.
DummyHierarchy(h$mapsFrom, h$mapsTo, h$sign, h$level,
               mapsInput = c(h$mapsFrom[!(h$mapsFrom \%in\% h$mapsTo)], "Norway", "Finland"))
}
\author{
Øyvind Langsrud
}
