% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Div.R
\name{RoundWhole}
\alias{RoundWhole}
\title{Round values that are close two whole numbers}
\usage{
RoundWhole(x, digits = 9, onlyZeros = FALSE)
}
\arguments{
\item{x}{vector or matrix}

\item{digits}{parameter to \code{\link{round}}}

\item{onlyZeros}{Only round values close to zero}
}
\value{
Modified x
}
\description{
Round values that are close two whole numbers
}
\details{
When \code{digits} is \code{NA}, \code{Inf} or \code{NULL}, input is returned unmodified.
When there is more than one element in \code{digits} or \code{onlyZeros},
rounding is performed column-wise.
}
\examples{
x <- c(0.0002, 1.00003, 3.00014)
RoundWhole(x)     # No values rounded
RoundWhole(x, 4)  # One value rounded
RoundWhole(x, 3)  # All values rounded
RoundWhole(x, NA) # No values rounded (always)
RoundWhole(x, 3, TRUE)  # One value rounded
RoundWhole(cbind(x, x, x), digits = c(3, 4, NA))
RoundWhole(cbind(x, x), digits = 3, onlyZeros = c(FALSE, TRUE))
}
\author{
Øyvind Langsrud
}
